/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.utils.Checker;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SerializeUtil {
    private static final ThreadLocal<LinkedBuffer> BUFFERS = new ThreadLocal();
    private static final Map<Class<?>, Schema<?>> schemaCache = new HashMap();

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        RuntimeSchema schema = schemaCache.get(clazz);
        if (schema == null) {
            schema = RuntimeSchema.createFrom(clazz);
            schemaCache.put(clazz, (Schema<?>)schema);
        }
        return schema;
    }

    private static LinkedBuffer getBuffer() {
        LinkedBuffer buffer = BUFFERS.get();
        if (buffer == null) {
            buffer = LinkedBuffer.allocate((int)4096);
            BUFFERS.set(buffer);
        }
        return buffer;
    }

    public static <T extends Serializable> byte[] obj2Bit(T obj) {
        if (Checker.isEmpty(obj)) {
            return null;
        }
        Schema<?> schema = SerializeUtil.getSchema(obj.getClass());
        LinkedBuffer buffer = SerializeUtil.getBuffer();
        try {
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw DartCode.SERIALIZE_ERROR.exception(e);
        }
        finally {
            buffer.clear();
        }
    }

    public static <T extends Serializable> T bit2Obj(byte[] bytes, Class<T> clazz) {
        if (Checker.isEmpty((Object)bytes)) {
            return null;
        }
        try {
            Schema<T> schema = SerializeUtil.getSchema(clazz);
            Serializable message = (Serializable)schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)message, schema);
            return (T)message;
        }
        catch (Exception e) {
            throw DartCode.SERIALIZE_ERROR.exception(e);
        }
    }
}

