/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.DateUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionUtil {
    static Logger logger = Logger.getLogger(SessionUtil.class.getName());
    private static Map<Serializable, Map<Serializable, Serializable>> SESSION = new ConcurrentHashMap<Serializable, Map<Serializable, Serializable>>();
    private static Map<Serializable, Long> SESSION_TIMEOUT = new ConcurrentHashMap<Serializable, Long>();

    private static void run() {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(500L);
                        if (Checker.isEmpty(SESSION_TIMEOUT)) {
                            return;
                        }
                        long cur = DateUtil.currentTimeMillis();
                        Set<Serializable> keys = SESSION_TIMEOUT.keySet();
                        Iterator<Serializable> iterator = keys.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            Serializable key = iterator.next();
                            Long timeout = SESSION_TIMEOUT.get(key);
                            if (cur <= timeout) continue;
                            SESSION.remove(key);
                            SESSION_TIMEOUT.remove(key);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                break;
            }
        });
        thread.setDaemon(true);
        thread.setName("SESSION-TIMEOUT-Thread");
        thread.start();
    }

    public static synchronized void init(Serializable sessionKey) {
        if (Checker.isEmpty(sessionKey)) {
            return;
        }
        if (SESSION.containsKey(sessionKey)) {
            return;
        }
        SessionUtil.updateTimeOut(sessionKey);
        if (SESSION.get(sessionKey) == null) {
            SESSION.put(sessionKey, new ConcurrentHashMap());
        }
    }

    private static void updateTimeOut(Serializable sessionKey) {
        if (Checker.isEmpty(sessionKey)) {
            return;
        }
        SESSION_TIMEOUT.put(sessionKey, DateUtil.currentTimeMillis() + 1800000L);
    }

    public static <T extends Serializable> T get(Serializable sessionKey, Serializable itemKey) {
        if (Checker.isEmpty(sessionKey) || Checker.isEmpty(itemKey)) {
            return null;
        }
        Map<Serializable, Serializable> map = SESSION.get(sessionKey);
        if (map == null) {
            return null;
        }
        SessionUtil.updateTimeOut(sessionKey);
        return (T)map.get(itemKey);
    }

    public static void put(Serializable sessionKey, Serializable itemKey, Serializable itemValue) {
        if (Checker.isEmpty(sessionKey) || Checker.isEmpty(itemKey)) {
            return;
        }
        SessionUtil.init(sessionKey);
        Map<Serializable, Serializable> map = SESSION.get(sessionKey);
        if (itemValue == null) {
            map.remove(itemKey);
        } else {
            map.put(itemKey, itemValue);
        }
        SESSION.put(sessionKey, map);
    }

    static {
        SessionUtil.run();
    }
}

