/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class Similarity {
    public static float cos(String a, String b) {
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChar = a.chars().boxed().collect(Collectors.toSet());
        Set bChar = b.chars().boxed().collect(Collectors.toSet());
        HashMap<Integer, Integer> aMap = new HashMap<Integer, Integer>(aChar.size());
        HashMap<Integer, Integer> bMap = new HashMap<Integer, Integer>(bChar.size());
        for (Integer a1 : aChar) {
            aMap.put(a1, aMap.getOrDefault(a1, 0) + 1);
        }
        for (Integer b1 : bChar) {
            bMap.put(b1, bMap.getOrDefault(b1, 0) + 1);
        }
        Set union = Similarity.union(aChar, bChar);
        int[] aVec = new int[union.size()];
        int[] bVec = new int[union.size()];
        ArrayList collect = new ArrayList(union);
        for (int i = 0; i < collect.size(); ++i) {
            aVec[i] = aMap.getOrDefault(collect.get(i), 0);
            bVec[i] = bMap.getOrDefault(collect.get(i), 0);
        }
        int p1 = 0;
        for (int i = 0; i < aVec.length; ++i) {
            p1 += aVec[i] * bVec[i];
        }
        float p2 = 0.0f;
        for (int i : aVec) {
            p2 += (float)(i * i);
        }
        p2 = (float)Math.sqrt(p2);
        float p3 = 0.0f;
        for (int i : bVec) {
            p3 += (float)(i * i);
        }
        p3 = (float)Math.sqrt(p3);
        return (float)p1 / (p2 * p3);
    }

    public static float hamming(String a, String b) {
        if (a == null || b == null) {
            return 0.0f;
        }
        if (a.length() != b.length()) {
            return 0.0f;
        }
        int disCount = 0;
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            ++disCount;
        }
        return (float)disCount / (float)a.length();
    }

    public static float levenshtein(String a, String b) {
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        int editDistance = Similarity.editDis(a, b);
        return 1.0f - (float)editDistance / (float)Math.max(a.length(), b.length());
    }

    public static float sorensenDice(String a, String b) {
        Set bChars;
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChars = a.chars().boxed().collect(Collectors.toSet());
        int intersect = Similarity.intersection(aChars, bChars = b.chars().boxed().collect(Collectors.toSet())).size();
        if (intersect == 0) {
            return 0.0f;
        }
        int aSize = aChars.size();
        int bSize = bChars.size();
        return 2.0f * (float)intersect / (float)(aSize + bSize);
    }

    public static float jaccard(String a, String b) {
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChar = a.chars().boxed().collect(Collectors.toSet());
        Set bChar = b.chars().boxed().collect(Collectors.toSet());
        HashSet result = new HashSet();
        int intersection = Similarity.intersection(aChar, bChar).size();
        if (intersection == 0) {
            return 0.0f;
        }
        int union = Similarity.union(aChar, bChar).size();
        return (float)intersection / (float)union;
    }

    private static Set intersection(Set a, Set b) {
        HashSet res = new HashSet();
        res.addAll(a);
        res.retainAll(b);
        return res;
    }

    private static Set union(Set a, Set b) {
        HashSet res = new HashSet();
        res.addAll(a);
        res.addAll(b);
        return res;
    }

    private static Set difference(Set a, Set b) {
        HashSet res = new HashSet();
        res.addAll(a);
        res.removeAll(b);
        return res;
    }

    private static int editDis(String a, String b) {
        int aLen = a.length();
        int bLen = b.length();
        if (aLen == 0) {
            return aLen;
        }
        if (bLen == 0) {
            return bLen;
        }
        int[][] v = new int[aLen + 1][bLen + 1];
        for (int i = 0; i <= aLen; ++i) {
            for (int j = 0; j <= bLen; ++j) {
                v[i][j] = i == 0 ? j : (j == 0 ? i : (a.charAt(i - 1) == b.charAt(j - 1) ? v[i - 1][j - 1] : 1 + Math.min(v[i - 1][j - 1], Math.min(v[i][j - 1], v[i - 1][j]))));
            }
        }
        return v[aLen][bLen];
    }
}

