/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SyncContainer<T> {
    private final CountDownLatch latch;
    private T data;
    private Exception exception;

    public SyncContainer() {
        this.latch = new CountDownLatch(1);
    }

    public SyncContainer(T defaultValue) {
        this.data = defaultValue;
        this.latch = new CountDownLatch(1);
    }

    public Optional<T> safeGetOptional() {
        try {
            this.latch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(this.data);
    }

    public T safeGet() {
        try {
            this.latch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.data;
    }

    public T safeGetOrThrow() throws Exception {
        try {
            this.latch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.data;
    }

    public T get() throws InterruptedException {
        this.latch.await();
        return this.data;
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException {
        this.latch.await(timeout, unit);
        return this.data;
    }

    public synchronized void set(T data) {
        this.data = data;
        this.latch.countDown();
    }

    public synchronized void finish() {
        this.latch.countDown();
    }

    public synchronized void error(Exception exception) {
        this.exception = exception;
        this.latch.countDown();
    }
}

