/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Charsets;
import im.dart.boot.common.utils.ByteUtil;
import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.CodingTool;
import im.dart.boot.common.utils.DateUtil;
import im.dart.boot.common.utils.Digest;
import java.util.Random;

public class TOTP {
    public static String generateKey() {
        byte[] key = new byte[20];
        new Random().nextBytes(key);
        return new String(CodingTool.b32Encode(key), Charsets.UTF_8);
    }

    public static String generateUrl() {
        return TOTP.generateUrl(null, null);
    }

    public static String generateUrl(String account, String mark) {
        if (Checker.isEmpty(account)) {
            account = "oen";
        }
        if (Checker.isEmpty(mark)) {
            mark = "oen-test";
        }
        return String.format("otpauth://totp/%s?secret=%s&issuer=%s&algorithm=SHA1&digits=6&period=30", account, TOTP.generateKey(), mark);
    }

    public static String generate(String key) {
        return TOTP.generate(key, 30, 6);
    }

    public static String generate(String key, int step) {
        return TOTP.generate(key, step, 6);
    }

    public static String generate(String secret, int period, int digits) {
        Checker.asserts(Checker.isNotEmpty(secret));
        byte[] k = CodingTool.b32Decode(secret.toUpperCase().getBytes(Charsets.UTF_8));
        byte[] t = ByteUtil.long2bytes(DateUtil.currentTimeSecond() / (long)period);
        byte[] hash = Digest.HMAC_SHA1(t, k);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % 1000000;
        Object result = Integer.toString(otp);
        while (((String)result).length() < digits) {
            result = "0" + (String)result;
        }
        return result;
    }
}

