/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.utils.Checker;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadLocalUtil {
    private static final ThreadLocal<ConcurrentHashMap<Object, Object>> threadLocal = ThreadLocal.withInitial(() -> new ConcurrentHashMap());

    public static void put(Object key, Object value) {
        if (Checker.isEmpty(key)) {
            throw new IllegalArgumentException("Key can not be empty");
        }
        if (Checker.isEmpty(value)) {
            throw new IllegalArgumentException("Value can not be empty");
        }
        ConcurrentHashMap<Object, Object> map = threadLocal.get();
        map.put(key, value);
        threadLocal.set(map);
    }

    public static void putIgnoreEmpty(Object key, Object value) {
        if (Checker.isEmpty(key)) {
            return;
        }
        if (Checker.isEmpty(value)) {
            return;
        }
        ConcurrentHashMap<Object, Object> map = threadLocal.get();
        map.put(key, value);
        threadLocal.set(map);
    }

    public static <T> T get(Object key) {
        ConcurrentHashMap<Object, Object> map = threadLocal.get();
        return (T)map.get(key);
    }
}

