/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.data.ITreeNode;
import im.dart.boot.common.utils.Checker;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TreeUtil {
    public static <T extends ITreeNode> Set<T> toTree(List<T> datas) {
        if (Checker.isEmpty(datas)) {
            return new HashSet();
        }
        Map<Object, ITreeNode> map = datas.stream().filter(tmp -> Checker.isNotEmpty(tmp.selfId())).collect(Collectors.toMap(tmp -> tmp.selfId(), tmp -> tmp));
        for (ITreeNode data : datas) {
            ITreeNode parent;
            Object parentId = data.parentId();
            if (Checker.isEmpty(parentId) || Checker.isEmpty(parent = map.get(parentId))) continue;
            parent.addChild(data);
        }
        return datas.stream().filter(tmp -> Checker.isEmpty(tmp.parentId())).collect(Collectors.toSet());
    }
}

