/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.extend.SnowflakeIdWorker;
import im.dart.boot.common.utils.Digest;
import java.math.BigDecimal;
import java.util.Random;

public class UUID {
    private static SnowflakeIdWorker IDWORKER = null;
    private static final Random random = new Random();

    public static void updateIdWorker(int datacenterId, int workId) {
        IDWORKER = new SnowflakeIdWorker(workId, datacenterId);
    }

    public static long uid() {
        return IDWORKER.nextId();
    }

    public static String uuid() {
        return java.util.UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String uuuid() {
        return Digest.MD5(String.format("%s-%s-%s", java.util.UUID.randomUUID().toString(), IDWORKER.nextId(), java.util.UUID.randomUUID().toString()));
    }

    public static int random(int max) {
        return random.nextInt(max);
    }

    public static int random(int low, int max) {
        int r = max - low;
        return random.nextInt(r) + low;
    }

    public static BigDecimal randomBigDecimal(int low, int max) {
        return new BigDecimal(String.valueOf(UUID.random(low, max)));
    }

    static {
        IDWORKER = new SnowflakeIdWorker(31L, 31L);
    }
}

