/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Charsets;
import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Objects;

public class UrlCoder {
    static final BitSet DONT_NEED_ENCODING;
    static final int CASE_DIFF = 32;

    public static String encode(String source) {
        return UrlCoder.encode(source, Charsets.UTF_8);
    }

    public static String encode(String source, Charset charset) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(charset, "Charset");
        boolean needToChange = false;
        StringBuilder out = new StringBuilder(source.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (DONT_NEED_ENCODING.get(c)) {
                if (c == ' ') {
                    needToChange = true;
                    out.append("%20");
                } else {
                    out.append(c);
                }
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= source.length() || (d = source.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < source.length() && !DONT_NEED_ENCODING.get(c = source.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(charset);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : source;
    }

    public static String decode(String source) {
        return UrlCoder.decode(source, Charsets.UTF_8);
    }

    public static String decode(String source, Charset charset) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(charset, "Charset");
        boolean needToChange = false;
        int numChars = source.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = source.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    String tmp;
                    if (i + 2 < numChars && (tmp = source.substring(i + 1, i + 3)) == "20") {
                        sb.append(" ");
                        i += 2;
                        continue block6;
                    }
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(source.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = source.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : source;
    }

    static {
        int i;
        DONT_NEED_ENCODING = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            DONT_NEED_ENCODING.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DONT_NEED_ENCODING.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            DONT_NEED_ENCODING.set(i);
        }
        DONT_NEED_ENCODING.set(32);
        DONT_NEED_ENCODING.set(45);
        DONT_NEED_ENCODING.set(95);
        DONT_NEED_ENCODING.set(46);
        DONT_NEED_ENCODING.set(42);
    }
}

