/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import im.dart.boot.common.constant.Charsets;
import im.dart.boot.common.data.StateBase;
import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.SyncContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class WebClient {
    private static final ConcurrentHashMap<String, List<Cookie>> COOKIE_STORE = new ConcurrentHashMap();
    private static OkHttpClient client = new OkHttpClient.Builder().cookieJar(new CookieJar(){

        public void saveFromResponse(@NotNull HttpUrl httpUrl, @NotNull List<Cookie> list) {
            COOKIE_STORE.put(httpUrl.host(), list);
        }

        public List<Cookie> loadForRequest(HttpUrl httpUrl) {
            ArrayList cookies = COOKIE_STORE.get(httpUrl.host());
            return cookies != null ? cookies : new ArrayList();
        }
    }).build();

    private static HttpResponse call(Request request) throws Exception {
        final SyncContainer container = new SyncContainer();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                container.error(e);
            }

            public void onResponse(Call call, Response response) {
                try {
                    HttpResponse httpResponse = new HttpResponse(response);
                    httpResponse.setRequestUrl(response.request().url().toString());
                    container.set(httpResponse);
                }
                catch (Exception e) {
                    container.error(e);
                }
            }
        });
        return (HttpResponse)container.safeGetOrThrow();
    }

    public static void upload(String method, String url, byte[] bytes) throws Exception {
        RequestBody requestBody = RequestBody.create((byte[])bytes, (MediaType)MediaType.parse((String)"application/octet-stream"));
        Request request = new Request.Builder().url(url).method(method, requestBody).build();
        WebClient.call(request);
    }

    public static void postUpload(String url, String key, byte[] bytes) throws Exception {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", key, RequestBody.create((byte[])bytes, (MediaType)MediaType.parse((String)"multipart/form-data"))).build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        WebClient.call(request);
    }

    public static byte[] download(String url) throws Exception {
        Request request = new Request.Builder().url(url).get().build();
        HttpResponse res = WebClient.call(request);
        return res != null ? res.getBodyBytes() : null;
    }

    public static HttpResponse request(String url, String method, Map<String, String> headers, Map<String, String> params, String json) throws Exception {
        RequestBody requestBody = null;
        if (Checker.isNotEmpty(json)) {
            requestBody = RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json;charset=utf-8"));
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (Checker.isNotEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        Request.Builder request = new Request.Builder().url(urlBuilder.build()).method(method, requestBody);
        if (Checker.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return WebClient.call(request.build());
    }

    public static HttpResponse post(String url, String json) throws Exception {
        return WebClient.request(url, "POST", null, null, json);
    }

    public static HttpResponse get(String url, Map<String, String> params) throws Exception {
        return WebClient.request(url, "GET", null, params, null);
    }

    public static class HttpResponse
    extends StateBase {
        private String requestUrl;
        private int code;
        private String message;
        private Map<String, String> headers;
        private String bodyString;
        @JsonIgnore
        private byte[] bodyBytes;

        public String getBodyString() {
            if (Checker.isNotEmpty(this.bodyString)) {
                return this.bodyString;
            }
            if (Checker.isNotEmpty((Object)this.bodyBytes)) {
                this.bodyString = new String(this.bodyBytes, Charsets.UTF_8);
            }
            return this.bodyString;
        }

        public byte[] getBodyBytes() {
            return this.bodyBytes;
        }

        public void setBodyBytes(byte[] bodyBytes) {
            this.bodyBytes = bodyBytes;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }

        public void setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public String getHeader(String name) {
            if (Checker.isEmpty(this.headers)) {
                return null;
            }
            return this.headers.get(name);
        }

        public HttpResponse(Response response) throws IOException {
            if (Checker.isEmpty(response)) {
                return;
            }
            this.setBodyBytes(response.body().bytes());
            this.setCode(response.code());
            this.setMessage(response.message());
            Headers hds = response.headers();
            if (Checker.isEmpty(hds)) {
                return;
            }
            Set headerNames = hds.names();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String headerName : headerNames) {
                headers.put(headerName, hds.get(headerName));
            }
            this.setHeaders(headers);
        }

        @Override
        public boolean isSuccess() {
            return this.code >= 200 && this.code < 300;
        }
    }
}

