package im.dart.boot.common.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import im.dart.boot.common.extend.MaskingSerializer;

import java.lang.annotation.*;

/**
 * 字符串数据脱敏注解
 *
 * @author Kevin.Xu
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
@JacksonAnnotationsInside
@JsonSerialize(using = MaskingSerializer.class)
public @interface Masking {

    /**
     * 字符安是否显示 true:需要显示  false:不需要显示
     *
     * @return TODO
     */
    boolean show() default false;

    /**
     * 如果显示,不设置此项则显示原始字符串，设置了则显示替换字符串
     *
     * @return TODO
     */
    String character() default "******";

    /**
     * 左边保留多少位源
     *
     * @return TODO
     */
    int left() default 0;

    /**
     * 右边保留多少位源
     *
     * @return TODO
     */
    int right() default 0;
}
