package im.dart.boot.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import java.util.concurrent.TimeUnit;

public class TimeoutCache<K, V> {
    private final Cache<K, V> cache;

    private TimeoutCache(int maxSize, long duration, TimeUnit unit) {
        cache = CacheBuilder.newBuilder().maximumSize(maxSize).initialCapacity(maxSize / 3).expireAfterAccess(duration, unit).build();
    }

    private TimeoutCache(long duration, TimeUnit unit) {
        cache = CacheBuilder.newBuilder().expireAfterAccess(duration, unit).build();
    }

    public static <K, V> TimeoutCache<K, V> create(int maxSize, long duration, TimeUnit unit) {
        return new TimeoutCache<>(maxSize, duration, unit);
    }

    public static <K, V> TimeoutCache<K, V> create(long duration, TimeUnit unit) {
        return new TimeoutCache<>(duration, unit);
    }

    public void put(K k, V v) {
        this.cache.put(k, v);
    }

    public V get(K k) {
        return this.cache.getIfPresent(k);
    }

    public void remove(K k) {
        this.cache.invalidate(k);
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}
