package im.dart.boot.common.constant;

import im.dart.boot.common.data.Code;

/**
 * OEN系统通用错误定义
 *
 * @author Kevin.Xu
 */
public class DartCode {
    public static Code SUCCESS = new Code(200, 1, "OK", "请求已成功");


    public static Code UPDATE_SUCCESS = new Code(201, 1, "Update Success", "新建或修改数据成功");
    public static Code REQUEST_ASYNC_QUEUE = new Code(202, 1, "Request Async Queue", "一个请求已经进入后台排队（异步任务）");
    public static Code DEL_SUCCESS = new Code(204, 1, "Delete Success", "删除数据成功");
    public static Code BAD_REQUEST = new Code(400, 1, "Bad Request", "错误的请求");
    public static Code UNAUTHORIZED = new Code(401, 1, "Unauthorized", "未认证");
    public static Code FORBIDDEN = new Code(403, 1, "Forbidden", "拒绝执行");
    public static Code NOT_FOUND = new Code(404, 1, "Not Found", "资源未发现");
    public static Code METHOD_NOT_ALLOWED = new Code(405, 1, "Method Not Allowed", "请求方法不被允许");
    public static Code NOT_ACCEPTABLE = new Code(406, 1, "Not Acceptable", "请求不可接受");
    public static Code REQUEST_TIMEOUT = new Code(408, 1, "Request Timeout", "请求超时");
    public static Code RESOURCE_REMOVED = new Code(410, 1, "Resources Removed", "请求的资源被永久删除，且不会再得到的。");
    public static Code UNSUPPORTED_MEDIA_TYPE = new Code(415, 1, "Unsupported Media Type", "请求中的类型并不是服务器中所支持的格式");
    public static Code CHECK_ERROR = new Code(422, 1, "Check Error", "当创建一个对象时，发生一个验证错误。");
    public static Code LOCKED = new Code(423, 1, "Locked", "当前资源被锁定");
    public static Code UPGRADE_REQUIRED = new Code(426, 1, "Upgrade Required", "必须升级协议");
    public static Code TOO_MANY_REQUESTS = new Code(429, 1, "Too Many Requests", "太多的请求");
    public static Code SERVER_ERROR = new Code(500, 1, "Internal Server Error", "服务器遇到了一个未曾预料的错误");
    public static Code NOT_IMPLEMENTED = new Code(501, 1, "Not Implemented", "服务器不支持当前请求所需要的功能");
    public static Code BAD_GATEWAY = new Code(502, 1, "Bad Gateway", "错误的网关");
    public static Code SERVICE_UNAVAILABLE = new Code(503, 1, "Service Unavailable", "服务器维护");
    public static Code GATEWAY_TIMEOUT = new Code(504, 1, "Gateway Timeout", "网关超时");
    public static Code VERSION_NOT_SUPPORTED = new Code(505, 1, "Version Not Supported", "不支持的版本");


    public static Code NUMBER_RANGE_ERROR = new Code(100, 1, "Number Range Error", "数字范围错误");
    public static Code SERIALIZE_ERROR = new Code(100, 2, "Serialization Error", "序列化错误");
    public static Code DIGEST_ERROR = new Code(100, 3, "Digest Error", "提取摘要信息错误");


    public static Code RECEIVED_DATA_EMPTY = new Code(101, 1, "Received Data Empty", "接收到的数据为空");
    public static Code RECEIVED_FIELD_INVALID = new Code(101, 2, "Received Field Invalid", "接收到的字段无效");
    public static Code PARAMETER_ERROR = new Code(117, 0, "The parameter is error", "参数错误");
    public static Code PARAMETER_IS_EMPTY = new Code(102, 1, "The parameter is empty", "参数为空");
    public static Code PARAMETER_FORMAT_ERROR = new Code(102, 2, "The parameter format error", "参数格式错误");
    public static Code PARAMETER_VALUE_RANGE_ERROR = new Code(102, 3, "The parameter value range error", "参数值不在范围内");


    public static Code DATA_ALREADY_EXISTS = new Code(103, 1, "Data Already Exists", "数据已经存在");
    public static Code DATA_NOT_FOUND = new Code(103, 2, "The data not fount", "数据没找到");
    public static Code DUPLICATE_ERROR = new Code(103, 3, "Duplicate data", "数据重复");
    public static Code DATA_MISMATCH = new Code(103, 4, "Data mismatch", "数据不匹配");


    public static Code ENCRYPTION_FAILED = new Code(104, 1, "Data encryption failed", "数据加密失败");
    public static Code DECRYPTION_FAILED = new Code(104, 2, "Data decryption failed", "数据解密失败");


    public static Code ZIP_COMPRESS_ERROR = new Code(105, 1, "Data compression failed", "数据压缩失败");
    public static Code ZIP_UNCOMPRESS_ERROR = new Code(105, 2, "Data decompression failed", "数据解压失败");


    public static Code HTTP_DOWN_ERROR = new Code(106, 1, "Http Download Error", "网络下载错误");
    public static Code FILE_UPLOAD_FAIL = new Code(106, 2, "File upload failed", "文件上传失败");


    public static Code LIMIT_REQUEST = new Code(107, 1, "Request limited", "请求被限制");
    public static Code LIMIT_REQUEST_DEMOTE = new Code(107, 2, "Request is downgraded", "请求被降级");
    public static Code LIMIT_REQUEST_NOT_AVAILABLE = new Code(107, 2, "Request not available", "请求不可用");
}
