package im.dart.boot.common.data;

import im.dart.boot.common.exception.DartException;
import im.dart.boot.common.utils.Checker;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 问题代码结构
 *
 * @author Kevin.Xu
 */
@ApiModel("错误码")
public class Code extends Base implements EmptyBase {
    @ApiModelProperty("错误码")
    private Integer code;
    @ApiModelProperty("错误码-字码")
    private Integer subCode;
    @ApiModelProperty("错误消息")
    private String message;
    @ApiModelProperty("附带信息")
    private String attached;
    @ApiModelProperty("出错原因")
    private String reason;
    @ApiModelProperty("可能的解决方案")
    private String solution;

    @Override
    public boolean isEmpty() {
        return Checker.hasEmpty(code);
    }

    public Code(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Code(Code code, String message) {
        this.code = code.code;
        this.subCode = code.subCode;
        this.attached = code.attached;

        this.message = message;
    }

    public Code(int code, String message, String attached) {
        this.code = code;
        this.message = message;
        this.attached = attached;
    }

    public Code(int code, int subCode, String message, String attached) {
        this.code = code;
        this.subCode = subCode;
        this.message = message;
        this.attached = attached;
    }

    public Code subCode(int subCode) {
        this.subCode = subCode;
        return this;
    }

    public Code attached(String attached) {
        this.attached = attached;
        return this;
    }

    public Code reason(String reason) {
        this.reason = reason;
        return this;
    }

    public Code solution(String solution) {
        this.solution = solution;
        return this;
    }

    public DartException exception() {
        return new DartException(this);
    }

    public DartException exception(String attached) {
        this.attached = attached;
        return new DartException(this);
    }

    public DartException exception(Throwable error) {
        return new DartException(this, error);
    }

    public <T> Result<T> result(T data) {
        return new Result<>(this, data);
    }

    public Result result() {
        return new Result(this, null);
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Integer getSubCode() {
        return subCode;
    }

    public void setSubCode(Integer subCode) {
        this.subCode = subCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getAttached() {
        return attached;
    }

    public void setAttached(String attached) {
        this.attached = attached;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getSolution() {
        return solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }
}
