package im.dart.boot.common.data;

import java.io.Serializable;
import java.util.Set;

/**
 * @author admin
 */
public interface ITreeNode<ID extends Serializable, T extends ITreeNode> {
    /**
     * 获得本数据的id
     *
     * @return 自己的Id
     */
    public ID selfId();

    /**
     * 获得本数据的父类数据ID
     *
     * @return 父级Id
     */
    public ID parentId();

    /**
     * 把元素添加到自己的子节点
     *
     * @param data
     */
    public void addChild(T data);

    /**
     * @return 获得所有的子类
     */
    public Set<T> getChildren();
}
