package im.dart.boot.common.data;

import im.dart.boot.common.utils.Checker;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Calendar;

/**
 * @author Kevin.Xu
 */
@ApiModel("键值对结构")
public class IdCardData extends Base {
    /**
     * 出生年
     */
    @ApiModelProperty("出生年")
    private int year;
    /**
     * 出生月
     */
    @ApiModelProperty("出生月")
    private int month;
    /**
     * 出生日
     */
    @ApiModelProperty("出生日")
    private int day;
    /**
     * 出生年月日 19901010
     */
    @ApiModelProperty("出生年月日 19901010")
    private String birthday;
    /**
     * 年龄
     */
    @ApiModelProperty("年龄")
    private int age;
    /**
     * 所在地域
     */
    @ApiModelProperty("所在地域")
    private String area;
    /**
     * 性别:M-男 F-女 N-未知
     */
    @ApiModelProperty("性别:M-男 F-女 N-未知")
    private String gender;

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public static IdCardData of(String id) {
        if (Checker.isEmpty(id)) {
            return null;
        }
        String idCard = id.replaceAll("[^0-9|Xx]", "");
        boolean valid = Checker.validIdCard(idCard);
        if (!valid) {
            return null;
        }
        int year = Integer.parseInt(idCard.substring(6, 10));
        int month = Integer.parseInt(idCard.substring(10, 12));
        int day = Integer.parseInt(idCard.substring(12, 14));
        int age = calcAge(year, month, day);
        if (age < 0) {
            return null;
        }

        String birthday = idCard.substring(6, 14);
        String gender = idCard.substring(16, 17);
        if (Integer.parseInt(gender) % 2 != 0) {
            gender = "M";
        } else {
            gender = "F";
        }
        String area = idCard.substring(0, 6);
        IdCardData data = new IdCardData();
        data.setBirthday(birthday);
        data.setYear(year);
        data.setMonth(month);
        data.setDay(day);
        data.setGender(gender);
        data.setArea(area);
        data.setAge(age);
        return data;
    }

    private static int calcAge(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        int cYear = c.get(Calendar.YEAR);
        int cMonth = c.get(Calendar.MONTH) + 1;
        int cDay = c.get(Calendar.DAY_OF_MONTH);
        if (year > cYear) {
            return -1;
        }
        int age = cYear - year;
        if (cMonth < month) {
            return age - 1;
        }
        if (cMonth == month) {
            if (cDay < day) {
                return age - 1;
            }
        }
        return age;
    }
}
