package im.dart.boot.common.data;

import java.awt.*;

/**
 * <p>描述：矩形定位</p>
 *
 * <p>创建时间：2021-12-17 10:49</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class Rectangle extends Base {

    private float minX, minY, maxX, maxY;

    public Rectangle() {
    }

    public Rectangle(float minX, float minY, float maxX, float maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public float getMinX() {
        return minX;
    }

    public void setMinX(float minX) {
        this.minX = minX;
    }

    public float getMinY() {
        return minY;
    }

    public void setMinY(float minY) {
        this.minY = minY;
    }

    public float getMaxX() {
        return maxX;
    }

    public void setMaxX(float maxX) {
        this.maxX = maxX;
    }

    public float getMaxY() {
        return maxY;
    }

    public void setMaxY(float maxY) {
        this.maxY = maxY;
    }

    public void drawRect(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int w = (int) (maxX - minX);
        int h = (int) (maxY - minY);
        graphics.drawRect((int) minX, (int) minY, w, h);
    }

    public void drawLine(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.drawLine((int) minX, (int) minY, (int) maxX, (int) maxY);
    }
}
