package im.dart.boot.common.data;


import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.utils.Checker;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 带Code的结果数据
 *
 * @author Kevin.Xu
 */
@ApiModel("统一的返回数据结构")
public class Result<T> extends Base implements EmptyBase {
    @ApiModelProperty("错误码")
    private Code code;
    @ApiModelProperty("数据")
    private T data;

    @Override
    public boolean isEmpty() {
        return Checker.isAllEmpty(code, data);
    }

    public Result() {
    }

    public Result(T data) {
        this.data = data;
    }

    public Result(Code code, T data) {
        this.code = code;
        this.data = data;
    }

    public Code getCode() {
        return code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static Result of(Code code) {
        return new Result(code, null);
    }

    public static <T> Result<T> of(T data) {
        return new Result<>(DartCode.SUCCESS, data);
    }

    public static <T> Result<T> of(Code code, T data) {
        return new Result<>(code, data);
    }

    public static Result SUCCESS() {
        return Result.of(DartCode.SUCCESS);
    }

    public static Result ERROR() {
        return Result.of(DartCode.SERVER_ERROR);
    }
}
