package im.dart.boot.common.data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * 树形数据结构
 *
 * @author Kevin.Xu
 */
public abstract class TreeNode<ID extends Serializable, T extends ITreeNode> implements ITreeNode<ID, T> {

    private Set<T> children;

    /**
     * 获得本数据的id
     *
     * @return 自己的Id
     */
    public abstract ID selfId();

    /**
     * 获得本数据的父类数据ID
     *
     * @return 父级Id
     */
    public abstract ID parentId();

    /**
     * 添加子节点到自己的节点
     *
     * @param data
     */
    public void addChild(T data) {
        if (children == null) {
            children = new HashSet<>();
        }
        children.add(data);
    }

    public Set<T> getChildren() {
        return children;
    }
}

