package im.dart.boot.common.data;

import im.dart.boot.common.utils.Checker;

/**
 * <p>描述：WebUserAgent解析</p>
 *
 * <p>创建时间：2022-01-19 11:17</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class WebUserAgent extends Base {
    private String family;              // 族信息，通常一个公司的一系列产品会形成一个族。
    private String major;               // 大版本号
    private String minor;               // 小版本号
    private String patch;               // 补丁版本
    private String deviceFamily;        // 设备族信息
    private String deviceBrand;         // 设备品牌
    private String deviceModel;         // 设备类型
    private String osFamily;            // 操作系统族信息
    private String osPatch;             // 操作系统补丁版本
    private String osMajor;             // 操作系统大版本号
    private String osMinor;             // 操作系统小版本号
    private String osPatchMinor;        // 操作系统补丁的小版本号

    public WebUserAgent() {
    }

    public WebUserAgent(String userAgent) {
        if (Checker.isEmpty(userAgent)) {
            return;
        }

    }

    public String getFamily() {
        return family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }

    public String getMinor() {
        return minor;
    }

    public void setMinor(String minor) {
        this.minor = minor;
    }

    public String getPatch() {
        return patch;
    }

    public void setPatch(String patch) {
        this.patch = patch;
    }

    public String getDeviceFamily() {
        return deviceFamily;
    }

    public void setDeviceFamily(String deviceFamily) {
        this.deviceFamily = deviceFamily;
    }

    public String getDeviceBrand() {
        return deviceBrand;
    }

    public void setDeviceBrand(String deviceBrand) {
        this.deviceBrand = deviceBrand;
    }

    public String getDeviceModel() {
        return deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getOsFamily() {
        return osFamily;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public String getOsPatch() {
        return osPatch;
    }

    public void setOsPatch(String osPatch) {
        this.osPatch = osPatch;
    }

    public String getOsMajor() {
        return osMajor;
    }

    public void setOsMajor(String osMajor) {
        this.osMajor = osMajor;
    }

    public String getOsMinor() {
        return osMinor;
    }

    public void setOsMinor(String osMinor) {
        this.osMinor = osMinor;
    }

    public String getOsPatchMinor() {
        return osPatchMinor;
    }

    public void setOsPatchMinor(String osPatchMinor) {
        this.osPatchMinor = osPatchMinor;
    }
}
