package im.dart.boot.common.exception;

import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.data.Code;

/**
 * OEN 通用的顶层异常
 *
 * @author Kevin.Xu
 */
public class DartException extends RuntimeException {

    private final Code error;

    public DartException() {
        super(DartCode.SERVER_ERROR.toString());
        this.error = DartCode.SERVER_ERROR;
    }

    public DartException(Code error) {
        super(error.toString());
        this.error = error;
    }

    public DartException(Throwable error) {
        super(error);
        this.error = new Code(DartCode.SERVER_ERROR, error.getMessage());
    }

    public DartException(Code error, Throwable exception) {
        super(error.toString(), exception);
        this.error = error;
    }

    public Code getErrorCode() {
        return this.error;
    }
}
