package im.dart.boot.common.extend;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import im.dart.boot.common.annotation.Masking;
import im.dart.boot.common.utils.Checker;

import java.io.IOException;
import java.util.Objects;

/**
 * <p>描述: 暂无描述信息</p>
 *
 * <p>创建时间：2022-09-08 11:33</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class MaskingSerializer extends JsonSerializer<String> implements ContextualSerializer {

    private Masking masking;

    public MaskingSerializer() {
    }

    public MaskingSerializer(Masking masking) {
        this.masking = masking;
    }

    @Override
    public void serialize(String origin, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (Checker.isEmpty(origin) || Checker.isEmpty(masking)) {
            jsonGenerator.writeString("");
            return;
        }
        int len = origin.length();
        int total = masking.left() + masking.right();
        if (!masking.show()) {
            jsonGenerator.writeString("");
        } else if (total <= 0) {
            jsonGenerator.writeString(masking.character());
        } else if (total >= len) {
            jsonGenerator.writeString(origin);
        } else {
            String start = "";
            if (masking.left() > 0) {
                start = origin.substring(0, masking.left());
            }
            String end = "";
            if (masking.right() > 0) {
                end = origin.substring(len - masking.right());
            }
            jsonGenerator.writeString(String.format("%s%s%s", start, masking.character(), end));
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (Checker.isEmpty(beanProperty)) {
            return serializerProvider.findNullValueSerializer(null);
        }
        if (!Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }

        Masking mask = beanProperty.getAnnotation(Masking.class);
        if (Checker.isEmpty(mask)) {
            mask = beanProperty.getContextAnnotation(Masking.class);
        }
        if (Checker.isEmpty(mask)) {
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return new MaskingSerializer(mask);
    }
}
