package im.dart.boot.common.match.sift.io;

import im.dart.boot.common.match.sift.scale.KDFeaturePoint;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>描述：暂无描述信息</p>
 *
 * <p>创建时间：2021-12-16 18:16</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class KDFeaturePointInfoReader {

    public static KDFeaturePointListInfo readComplete(String filePath) {

        ObjectInputStream fis = null;
        try {
            File f = new File(filePath);
            fis = new ObjectInputStream(new FileInputStream(f));
            int count = fis.readInt();
            if (count == 0) return null;
            List<KDFeaturePoint> al = new ArrayList<KDFeaturePoint>();
            for (int i = 0; i < count; i++) {
                KDFeaturePoint kp = (KDFeaturePoint) fis.readObject();
                al.add(kp);
            }
            int w = fis.readInt();
            int h = fis.readInt();
            KDFeaturePointListInfo kfl = new KDFeaturePointListInfo();
            kfl.setImageFile(f.getName());
            kfl.setList(al);
            kfl.setWidth(w);
            kfl.setHeight(h);
            return kfl;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                }
            }
        }

    }

    public static KDFeaturePointListInfo readComplete(ObjectInputStream fis, String name) {

        try {
            int count = fis.readInt();
            if (count == 0) return null;
            List<KDFeaturePoint> al = new ArrayList<KDFeaturePoint>();
            for (int i = 0; i < count; i++) {
                KDFeaturePoint kp = (KDFeaturePoint) fis.readObject();
                al.add(kp);
            }
            int w = fis.readInt();
            int h = fis.readInt();
            KDFeaturePointListInfo kfl = new KDFeaturePointListInfo();
            kfl.setImageFile(name);
            kfl.setList(al);
            kfl.setWidth(w);
            kfl.setHeight(h);
            return kfl;
        } catch (Exception e) {
            return null;
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                }
            }
        }
    }
}
