package im.dart.boot.common.match.sift.scale;

import im.dart.boot.common.match.kdtree.IKDTreeDomain;

/**
 * <p>描述：该类主要将FeaturePoint的feature修改为整数以便在KDTree上查找</p>
 *
 * <p>创建时间：2021-12-16 18:18</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class KDFeaturePoint extends IKDTreeDomain implements Cloneable {

    private static final long serialVersionUID = 814942706491557514L;
    public float x, y;
    public float scale;
    public float orientation;

    public KDFeaturePoint() {
    }

    public KDFeaturePoint(FeaturePoint fp) {
        if (!fp.hasFeatures) throw (new IllegalArgumentException(
                "While trying to generate integer "
                        + "vector: source FeaturePoint has no feature vector yet"));
        x = fp.x;
        y = fp.y;
        scale = fp.scale;
        orientation = fp.orientation;
        dim = fp.features.length;
        descriptor = new int[dim];
        for (int d = 0; d < dim; ++d) {
            descriptor[d] = (int) (255.0 * fp.features[d]);
            if (descriptor[d] < 0 || descriptor[d] > 255) {
                throw (new IllegalArgumentException("Resulting integer descriptor k is not 0 <= k <= 255"));
            }
        }
    }

    public KDFeaturePoint clone() {
        KDFeaturePoint other = new KDFeaturePoint();
        other.dim = dim;
        other.x = x;
        other.y = y;
        other.scale = scale;
        other.orientation = orientation;
        other.descriptor = new int[dim];
        System.arraycopy(descriptor, 0, other.descriptor, 0, dim);
        return other;
    }
}
