package im.dart.boot.common.match.sift.scale;

import im.dart.boot.common.match.sift.ImagePixelArray;

import java.util.ArrayList;

/**
 * <p>描述：暂无描述信息</p>
 *
 * <p>创建时间：2021-12-16 18:23</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class Pyramid {
    public ArrayList<OctaveSpace> octaves; // 该塔中一共有几个8度空间

    public int buildOctaves(ImagePixelArray source, float scale, int levelsPerOctave, float octaveSigm, int minSize) {
        this.octaves = new ArrayList<OctaveSpace>();
        OctaveSpace downSpace = null;
        ImagePixelArray prev = source;

        while (prev != null && prev.width >= minSize && prev.height >= minSize) {
            OctaveSpace osp = new OctaveSpace();

            // Create both the gaussian filtered images and the DOG maps
            osp.makeGaussianImgs(prev, scale, levelsPerOctave, octaveSigm);
            osp.makeGaussianDiffImgs();
            octaves.add(osp);
            prev = osp.getLastGaussianImg().halved();
            if (downSpace != null) downSpace.up = osp;
            osp.down = downSpace;
            downSpace = osp;
            scale *= 2.0;
        }
        return (octaves.size());
    }
}
