package im.dart.boot.common.parent;

import im.dart.boot.common.utils.SessionUtil;

import java.io.Serializable;

/**
 * <p>描述：Session工具的使用类</p>
 *
 * <p>创建时间：2021-10-29 14:11</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public abstract class SessionParent {

    protected abstract Serializable getSessionKey();

    public void putSession(Serializable key, Serializable value) {
        SessionUtil.put(this.getSessionKey(), key, value);
    }

    public <T extends Serializable> T getSession(Serializable key) {
        return SessionUtil.get(this.getSessionKey(), key);
    }
}
