package im.dart.boot.common.utils;

import im.dart.boot.common.constant.DartCode;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;

public class AESUtil {

    static {
        Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
    }

    public static byte[] encrypt(String content, String password) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(password.getBytes());
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(secureRandom);
            SecretKey secretKey = generator.generateKey();
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            return cipher.doFinal(content.getBytes());
        } catch (Exception ex) {
            ex.printStackTrace();
            throw DartCode.ENCRYPTION_FAILED.exception(ex);
        }
    }

    public static byte[] decrypt(byte[] content, String password) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(password.getBytes());
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(secureRandom);
            SecretKey secretKey = generator.generateKey();
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, secretKey);
            return cipher.doFinal(content);
        } catch (Exception ex) {
            ex.printStackTrace();
            throw DartCode.DECRYPTION_FAILED.exception(ex);
        }
    }

    public static byte[] decrypt(byte[] ivBytes, byte[] passBytes, byte[] encryptedBytes) {
        try {
            AlgorithmParameters ivKey = AlgorithmParameters.getInstance("AES");
            ivKey.init(new IvParameterSpec(ivBytes));

            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            Key sKeySpec = new SecretKeySpec(passBytes, "AES");

            cipher.init(Cipher.DECRYPT_MODE, sKeySpec, ivKey);
            return cipher.doFinal(encryptedBytes);
        } catch (Exception ex) {
            ex.printStackTrace();
            throw DartCode.DECRYPTION_FAILED.exception(ex);
        }
    }
}
