package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Magic;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * <p>描述：计算器</p>
 *
 * <p>创建时间：2021-11-01 17:54</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class Calc {

    public static int add(Integer one, Integer two) {
        if (one == null) {
            one = Magic.ZERO;
        }
        if (two == null) {
            two = Magic.ZERO;
        }
        return one + two;
    }

    public static int sub(Integer one, Integer two) {
        if (one == null) {
            one = Magic.ZERO;
        }
        if (two == null) {
            two = Magic.ZERO;
        }
        return one - two;
    }

    public static int mul(Integer one, Integer two) {
        if (one == null) {
            one = Magic.ZERO;
        }
        if (two == null) {
            two = Magic.ZERO;
        }
        return one * two;
    }

    public static int div(Integer one, Integer two) {
        if (one == null) {
            one = Magic.ZERO;
        }
        if (two == null || two == Magic.ZERO) {
            return Magic.ZERO;
        }
        return one / two;
    }

    public static BigDecimal add(BigDecimal one, BigDecimal two) {
        if (one == null) {
            one = BigDecimal.ZERO;
        }
        if (two == null) {
            two = BigDecimal.ZERO;
        }
        return one.add(two);
    }

    public static BigDecimal sub(BigDecimal one, BigDecimal two) {
        if (one == null) {
            one = BigDecimal.ZERO;
        }
        if (two == null) {
            two = BigDecimal.ZERO;
        }
        return one.subtract(two);
    }

    public static BigDecimal mul(BigDecimal one, BigDecimal two) {
        if (one == null) {
            one = BigDecimal.ZERO;
        }
        if (two == null) {
            two = BigDecimal.ZERO;
        }
        return one.multiply(two);
    }

    public static BigDecimal div(BigDecimal one, BigDecimal two) {
        if (one == null) {
            one = BigDecimal.ZERO;
        }
        if (two == null || two.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return one.divide(two, 2, RoundingMode.DOWN);
    }
}
