package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Charsets;

import java.nio.charset.Charset;

/**
 * <p>描述：暂无描述信息</p>
 *
 * <p>创建时间：2021-09-27 16:45</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class CharsetUtil {

    public static byte[] gbk2utf8(byte[] bytes) {
        return convert(bytes, Charsets.GBK, Charsets.UTF_8);
    }

    public static byte[] convert(byte[] bytes, Charset source, Charset target) {
        if (Checker.isEmpty(bytes)) {
            return bytes;
        }
        return new String(bytes, source).getBytes(target);
    }

    public static String convert(String text, Charset source, Charset target) {
        return new String(text.getBytes(source), target);
    }

    public static String gbk2utf8(String text) {
        return convert(text, Charsets.GBK, Charsets.UTF_8);
    }

    public static String utf2gbk(String text) {
        return convert(text, Charsets.UTF_8, Charsets.GBK);
    }
}
