package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Charsets;

/**
 * <p>描述：编码工具</p>
 *
 * <p>创建时间：2021-11-16 15:30</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class CodingTool {
    private static final org.apache.commons.codec.binary.Base64 BASE_64 = new org.apache.commons.codec.binary.Base64();
    private static final org.apache.commons.codec.binary.Base32 BASE_32 = new org.apache.commons.codec.binary.Base32();

    public static byte[] b32Encode(byte[] bytes) {
        return BASE_32.encode(bytes);
    }

    public static String b32Encode(String str) {
        return BASE_32.encodeAsString(str.getBytes(Charsets.UTF_8));
    }

    public static byte[] b32Decode(byte[] bytes) {
        return BASE_32.decode(bytes);
    }

    public static String b32Decode(String str) {
        return new String(BASE_32.decode(str), Charsets.UTF_8);
    }

    public static byte[] b64Encode(byte[] bytes) {
        return BASE_64.encode(bytes);
    }

    public static String b64Encode(String str) {
        return BASE_64.encodeAsString(str.getBytes(Charsets.UTF_8));
    }

    public static byte[] b64Decode(byte[] bytes) {
        return BASE_64.decode(bytes);
    }

    public static String b64Decode(String str) {
        return new String(BASE_64.decode(str), Charsets.UTF_8);
    }
}
