package im.dart.boot.common.utils;

import im.dart.boot.common.constant.DartCode;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * <p>描述：Csv操作工具</p>
 *
 * <p>创建时间：2022-05-24 17:07</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class CsvUtil {

    private static final Logger log = LoggerFactory.getLogger(CsvUtil.class);

    public static <T extends CsvData> void save(String[] headers, List<T> list, String savePath) throws Exception {
        if (Checker.isEmpty(headers) || Checker.isEmpty(list) || Checker.isEmpty(savePath)) {
            throw DartCode.PARAMETER_IS_EMPTY.exception();
        }
        CSVFormat csvFormat = CSVFormat.Builder.create().setHeader(headers).build();
        CSVPrinter csvPrinter = new CSVPrinter(new FileWriter(savePath), csvFormat);
        list.stream().forEach(d -> {
            try {
                csvPrinter.printRecord(d.toRecord());
            } catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        });
        csvPrinter.flush();
        csvPrinter.close();
    }

    public static <T extends CsvData> List<T> read(String filePath, Class<T> clazz) throws Exception {
        Iterator<CSVRecord> read = CSVFormat.EXCEL.parse(new InputStreamReader(new FileInputStream(new File(filePath)))).stream().iterator();
        List<T> list = new ArrayList<>();
        while (read.hasNext()) {
            try {
                CSVRecord record = read.next();
                int size = record.size();
                String[] values = new String[size];
                for (int i = 0; i < size; i++) {
                    values[i] = record.get(i);
                }

                T obj = ReflectUtil.newObj(clazz);
                obj.set(values);
                list.add(obj);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return list;
    }

    public static interface CsvData {
        public String[] toRecord();

        public void set(String[] records);
    }
}
