package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Charsets;
import im.dart.boot.common.constant.DartCode;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.security.MessageDigest;

/**
 * 摘要算法
 *
 * @author Kevin.Xu
 */
public class Digest {

    private static final String DIGEST_SALT = "Z#Kql&wpeT8SR5aKx91oj";

    public static String SALT2MD5(String code) {
        String first = MD5(code);
        String tmp = String.format("%s_%s_%s", first, DIGEST_SALT, first);
        return MD5(tmp);
    }

    public static String MD5(String code) {
        return MD5(code.getBytes(Charsets.UTF_8));
    }

    public static String MD5(byte[] bytes) {
        try {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(bytes);
            byte[] md = mdInst.digest();
            return ByteUtil.toHex(md);
        } catch (Exception e) {
            throw DartCode.DIGEST_ERROR.exception(e);
        }
    }

    public static String SHA1(String str) {
        return sha(str, "SHA1");
    }

    public static String SHA256(String str) {
        return sha(str, "SHA-256");
    }

    public static String SHA512(String str) {
        return sha(str, "SHA-512");
    }

    public static String SHA1(final byte[] bytes) {
        return sha(bytes, "SHA1");
    }

    public static String SHA256(final byte[] bytes) {
        return sha(bytes, "SHA-256");
    }

    public static String SHA512(final byte[] bytes) {
        return sha(bytes, "SHA-512");
    }

    private static String sha(final String strText, final String strType) {
        return sha(strText.getBytes(Charsets.UTF_8), strType);
    }

    private static String sha(final byte[] bytes, final String strType) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(strType);
            messageDigest.update(bytes);
            byte[] digest = messageDigest.digest();
            return ByteUtil.toHex(digest);
        } catch (Exception e) {
            throw DartCode.DIGEST_ERROR.exception(e);
        }
    }

    public static byte[] HMAC_SHA1(String source, String key) {
        return hmacSha(source.getBytes(Charsets.UTF_8), key.getBytes(Charsets.UTF_8), "HmacSHA1");
    }

    public static byte[] HMAC_SHA1(byte[] source, byte[] key) {
        return hmacSha(source, key, "HmacSHA1");
    }

    public static byte[] HMAC_SHA256(byte[] source, byte[] key) {
        return hmacSha(source, key, "HmacSHA256");
    }

    public static byte[] HMAC_SHA512(byte[] source, byte[] key) {
        return hmacSha(source, key, "HmacSHA512");
    }

    private static byte[] hmacSha(byte[] source, byte[] key, String type) {
        try {
            Mac hmacSHA1 = Mac.getInstance("HmacSHA1");
            SecretKeySpec macKey = new SecretKeySpec(key, "AES");
            hmacSHA1.init(macKey);
            return hmacSHA1.doFinal(source);
        } catch (Exception e) {
            throw DartCode.DIGEST_ERROR.exception(e);
        }
    }
}
