package im.dart.boot.common.utils;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 * <p>描述：暂无描述信息</p>
 *
 * <p>创建时间：2022-07-11 09:55</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class Log {
    private static Logger logger = Logger.getLogger("Log");

    public static void log(String str) {
        logger.log(Level.INFO, str);
    }

    public static void log(Object obj) {
        logger.log(Level.INFO, JsonUtil.safeToJson(obj));
    }

    public static void log(String... strs) {
        if (Checker.isEmpty(strs)) {
            System.out.println("");
        }
        String str = Arrays.asList(strs).parallelStream().collect(Collectors.joining());
        logger.log(Level.INFO, str);
    }

    public static void log(Object... objs) {
        if (Checker.isEmpty(objs)) {
            System.out.println("");
        }
        String str = Arrays.asList(objs).parallelStream().map(JsonUtil::safeToJson).collect(Collectors.joining());
        logger.log(Level.INFO, str);
    }

    public static void logf(String fmt, Object... objs) {
        logger.log(Level.INFO, String.format(fmt, objs));
    }

    public static Logger get(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }
}
