package im.dart.boot.common.utils;

import im.dart.boot.common.data.Base;
import im.dart.boot.common.data.EmptyBase;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedList;

/**
 * <p>描述：Shell命令操作工具</p>
 *
 * <p>创建时间：2022-05-24 16:34</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class ShellUtil {

    public static ShellData exec(final String cmd) {
        if (Checker.isEmpty(cmd)) {
            return null;
        }
        return Runner.safeRun(() -> {
            ShellData data = new ShellData();
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String line;
            while ((line = out.readLine()) != null) {
                data.addLine(line);
            }
            while ((line = err.readLine()) != null) {
                data.addError(line);
            }
            return data;
        });
    }

    public static ShellData exec(final String adminPassword, final String cmd) {
        if (Checker.isEmpty(adminPassword)) {
            return exec(cmd);
        }

        return Runner.safeRun(() -> {
            ShellData data = new ShellData();
            String command = "echo \"" + adminPassword + "\" | sudo -S " + cmd;
//            String[] cmds = {"/bin/sh", "-c", command};
            String[] cmds = {"/bin/zsh", "-c", command};
            Process proc = Runtime.getRuntime().exec(cmds);
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String line;
            while ((line = out.readLine()) != null) {
                data.addLine(line);
            }
            while ((line = err.readLine()) != null) {
                data.addError(line);
            }
            return data;
        });
    }

    public static class ShellData extends Base implements EmptyBase {

        private LinkedList<String> lines = new LinkedList<>();
        private LinkedList<String> errors = new LinkedList<>();

        public boolean isEmpty() {
            return (Checker.isEmpty(lines) && Checker.isEmpty(errors));
        }

        public void print() {
            System.out.println("---- info ---------------------------------------");
            System.out.println(this.getLineStr());
            System.err.println("---- error ---------------------------------------");
            System.err.println(this.getErrorStr());
        }

        public boolean hasError() {
            return !Checker.isEmpty(errors);
        }

        public void addLine(String line) {
            if (Checker.isNotEmpty(line)) {
                this.lines.add(line.trim());
            }
        }

        public void addError(String error) {
            if (Checker.isNotEmpty(error)) {
                this.errors.add(error.trim());
            }
        }

        public String getLineStr() {
            if (Checker.isEmpty(lines)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line);
            }
            return sb.toString();
        }

        public String getErrorStr() {
            if (Checker.isEmpty(errors)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String line : errors) {
                sb.append(line);
            }
            return sb.toString();
        }

        public LinkedList<String> getLines() {
            return lines;
        }

        public LinkedList<String> getErrors() {
            return errors;
        }
    }
}
