package im.dart.boot.common.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/**
 * <p>描述：暂无描述信息</p>
 *
 * <p>创建时间：2022-06-27 15:13</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class StopWatch {
    private AtomicLong start = new AtomicLong(0);
    private AtomicLong end = new AtomicLong(0);

    private AtomicInteger countStop = new AtomicInteger(0);

    private StopWatch(boolean init) {
        if (init) {
            start.set(System.nanoTime());
        }
    }

    public static StopWatch create() {
        return new StopWatch(false);
    }

    public static StopWatch createStarted() {
        return new StopWatch(true);
    }

    public long costNanoTime() {
        return this.end.get() - this.start.get();
    }

    public int count() {
        return this.countStop.get();
    }

    public void start() {
        this.start.set(System.nanoTime());
    }

    public long stop() {
        this.end.set(System.nanoTime());
        this.countStop.addAndGet(1);
        return this.costNanoTime();
    }

    public void prettyPrint() {
        System.out.println(String.format("任务次数：%s  =>  总耗时：%s", this.countStop.get(), DateUtil.fmtRemainingNanoTime(this.costNanoTime())));
    }
}
