package im.dart.boot.common.utils;

import im.dart.boot.common.constant.DartCode;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;

/**
 * <p>描述：暂无描述信息</p>
 *
 * <p>创建时间：2022-06-27 15:50</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class StopWatchV2 {
    private String name;
    private static final int MAX_LEN = 100;
    private AtomicLongArray starts = new AtomicLongArray(MAX_LEN);
    private AtomicLongArray ends = new AtomicLongArray(MAX_LEN);

    private AtomicInteger idx = new AtomicInteger(0);

    private StopWatchV2(String name) {
        this.name = name;
        long nano = System.nanoTime();
        starts.set(idx.get(), nano);
        ends.set(idx.get(), nano);
    }

    public static StopWatchV2 create(String name) {
        StopWatchV2 sw = new StopWatchV2(name);
        sw.record();
        sw.reset();
        return sw;
    }

    public static StopWatchV2 create() {
        return create(UUID.uuid());
    }

    public void reset() {
        idx.set(0);
        long nano = System.nanoTime();
        starts.set(idx.get(), nano);
        ends.set(idx.get(), nano);
    }

    public void record() {
        if (idx.get() >= MAX_LEN) {
            throw DartCode.NUMBER_RANGE_ERROR.exception("Maximum number of times exceeded[100]");
        }
        long nano = System.nanoTime();
        this.ends.set(idx.get(), nano);
        this.starts.set(idx.incrementAndGet(), nano);
    }

    public long lastRecordTime() {
        int i = idx.get() - 1;
        if (i < 0) {
            return 0;
        }
        return this.ends.get(i) - this.starts.get(i);
    }

    public void prettyPrint() {
        int count = this.idx.get() - 1;
        long cs = this.ends.get(count) - this.starts.get(0);
        System.out.println("===== [" + this.name + "] " +
                "===============================================");
        System.out.println("任务次数\t\t开始时间\t\t\t\t结束时间\t\t\t\t耗时");
        for (int i = 0; i <= count; i++) {
            long start = starts.get(i);
            long end = ends.get(i);
            System.out.println(String.format("%s\t\t\t%s\t\t%s\t\t%s", i, start, end, DateUtil.fmtRemainingNanoTime(end - start)));
        }
        System.out.println(String.format("任务总次数：%s  =>  任务总耗时：%s", count + 1, DateUtil.fmtRemainingNanoTime(cs)));
        System.out.println("============================================================================");
    }
}
