package im.dart.boot.common.utils;

import java.util.concurrent.ConcurrentHashMap;

/**
 * <p>描述：暂无描述信息</p>
 *
 * <p>创建时间：2022-03-30 10:01</p>
 * <p>更新时间：暂无</p>
 *
 * @author Kevin.Xu
 * @version 1.0
 */
public class ThreadLocalUtil {
    private static final ThreadLocal<ConcurrentHashMap<Object, Object>> threadLocal = ThreadLocal.withInitial(() -> new ConcurrentHashMap<>());

    public static void put(Object key, Object value) {
        if (Checker.isEmpty(key)) {
            throw new IllegalArgumentException("Key can not be empty");
        }
        if (Checker.isEmpty(value)) {
            throw new IllegalArgumentException("Value can not be empty");
        }
        ConcurrentHashMap<Object, Object> map = threadLocal.get();
        map.put(key, value);
        threadLocal.set(map);
    }

    public static void putIgnoreEmpty(Object key, Object value) {
        if (Checker.isEmpty(key)) {
            return;
        }
        if (Checker.isEmpty(value)) {
            return;
        }
        ConcurrentHashMap<Object, Object> map = threadLocal.get();
        map.put(key, value);
        threadLocal.set(map);
    }

    public static <T> T get(Object key) {
        ConcurrentHashMap<Object, Object> map = threadLocal.get();
        return (T) map.get(key);
    }
}
