package im.dart.boot.common.utils;

import im.dart.boot.common.data.ITreeNode;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 树形结构处理工具
 *
 * @author Kevin.Xu
 */
public class TreeUtil {
    public static <T extends ITreeNode> Set<T> toTree(List<T> datas) {
        if (Checker.isEmpty(datas)) {
            return new HashSet<>();
        }

        Map<Object, T> map = datas.stream().filter(tmp -> Checker.isNotEmpty(tmp.selfId())).collect(Collectors.toMap(tmp -> tmp.selfId(), tmp -> tmp));

        for (T data : datas) {
            Object parentId = data.parentId();
            if (Checker.isEmpty(parentId)) {
                continue;
            }
            T parent = map.get(parentId);
            if (Checker.isEmpty(parent)) {
                continue;
            }
            parent.addChild(data);
        }

        return datas.stream().filter(tmp -> Checker.isEmpty(tmp.parentId())).collect(Collectors.toSet());
    }
}
