package im.dart.boot.common.utils;

import im.dart.boot.common.constant.DartCode;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

/**
 * @author Kevin.Xu
 */
public class XCrypt {
    private static final char[] HEX_NORMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEX_NORMAL_STR = "0123456789abcdef";
    private static final String HEX_TMP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int hexLen = 100;
    private static final List<String> hexs = new ArrayList<>(hexLen);

    static {
        gen();
    }

    /**
     * 加密 bin - en - hex - zip
     *
     * @param bytes
     * @return
     */
    public static byte[] en(byte[] bytes, byte[] pass) throws Exception {
        long t1 = System.currentTimeMillis();
        byte[] en = encrypt(bytes, pass);
        long t2 = System.currentTimeMillis();
        String hex = toHex(en);
        long t3 = System.currentTimeMillis();
        byte[] res = compress(hex.getBytes());
        long t4 = System.currentTimeMillis();
        return res;
    }

    /**
     * 解密 zip - hex - de - bin
     *
     * @param bytes
     * @param pass
     * @return
     * @throws Exception
     */
    public static byte[] de(byte[] bytes, byte[] pass) throws Exception {
        byte[] unzip = uncompress(bytes);
        byte[] hex = hexTo(new String(unzip));
        return decrypt(hex, pass);
    }

    public static String enAndHex(byte[] bytes, byte[] pass) throws Exception {
        byte[] res = en(bytes, pass);
        return toHex(res);
    }

    public static byte[] deWithHex(String content, byte[] pass) throws Exception {
        byte[] hex = hexTo(content);
        return de(hex, pass);
    }

    private static char[] getHexSource(int index) {
        String hexTmp = hexs.get(index);
        return hexTmp.toCharArray();
    }

    private static String getHexSourceStr(int index) {
        return hexs.get(index);
    }

    private static int toInt(byte[] bytes) {
        if (bytes == null || bytes.length != 2) {
            throw DartCode.SERIALIZE_ERROR.exception();
        }
        int c1 = (int) bytes[0];
        int c2 = (int) bytes[1];
        return Integer.valueOf(c1 + "" + (c2 < 10 ? "0" + c2 : c2));
    }

    private static byte[] toBytes(int num) {
        if (num > 10000 || num < 0) {
            throw DartCode.SERIALIZE_ERROR.exception();
        }

        if (num < 100) {
            return new byte[]{0x00, (byte) num};
        } else {
            String tmp = String.valueOf(num);
            int a1 = Integer.valueOf(tmp.substring(0, tmp.length() - 2));
            int a2 = Integer.valueOf(tmp.substring(tmp.length() - 2));
            return new byte[]{(byte) a1, (byte) a2};
        }
    }

    private static String toHex(byte[] bytes) {
        int byteLen = bytes.length;
        int index = UUID.random(hexLen);
        char[] hexTmp = getHexSource(index);
        StringBuilder result = new StringBuilder((byteLen + 1) * 2);

        byte[] indexBytes = toBytes(index);
        String hex = String.valueOf(HEX_NORMAL[(indexBytes[0] & 0xF0) >> 4]);
        result.append(hex);
        hex = String.valueOf(HEX_NORMAL[indexBytes[0] & 0x0F]);
        result.append(hex);
        hex = String.valueOf(HEX_NORMAL[(indexBytes[1] & 0xF0) >> 4]);
        result.append(hex);
        hex = String.valueOf(HEX_NORMAL[indexBytes[1] & 0x0F]);
        result.append(hex);

        for (int i = 0; i < bytes.length; i++) {
            hex = String.valueOf(hexTmp[(bytes[i] & 0xF0) >> 4]);
            result.append(hex);
            hex = String.valueOf(hexTmp[bytes[i] & 0x0F]);
            result.append(hex);
        }
        return result.toString();
    }

    private static byte[] hexTo(String hex) {
        byte indexFirstHigh = (byte) ((HEX_NORMAL_STR.indexOf(hex.charAt(0))) << 4);
        byte indexFirstLow = (byte) HEX_NORMAL_STR.indexOf(hex.charAt(1));
        byte indexFirst = (byte) (indexFirstHigh | indexFirstLow);

        byte indexLastHigh = (byte) ((HEX_NORMAL_STR.indexOf(hex.charAt(2))) << 4);
        byte indexLastLow = (byte) HEX_NORMAL_STR.indexOf(hex.charAt(3));
        byte indexLast = (byte) (indexLastHigh | indexLastLow);

        byte[] lenBytes = new byte[]{indexFirst, indexLast};
        int index = toInt(lenBytes);
        String hexTmp = getHexSourceStr(index);
        String content = hex.substring(4);
        int len = content.length() >> 1;
        byte[] result = new byte[len];
        byte high = 0;
        byte low = 0;
        for (int i = 0; i < len; i++) {
            high = (byte) ((hexTmp.indexOf(content.charAt(2 * i))) << 4);
            low = (byte) hexTmp.indexOf(content.charAt(2 * i + 1));
            result[i] = (byte) (high | low);
        }
        return result;
    }

    private static byte[] encrypt(byte[] bytes, byte[] pass) throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(pass);
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(secureRandom);
        SecretKey secretKey = generator.generateKey();
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.ENCRYPT_MODE, secretKey);
        return cipher.doFinal(bytes);
    }

    private static byte[] decrypt(byte[] bytes, byte[] pass) throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(pass);
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(secureRandom);
        SecretKey secretKey = generator.generateKey();
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, secretKey);
        return cipher.doFinal(bytes);
    }

    private static byte[] compress(byte[] inputByte) throws Exception {
        int len = 0;
        Deflater defl = new Deflater();
        defl.setInput(inputByte);
        defl.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] outputByte = new byte[1024];
        try {
            while (!defl.finished()) {
                len = defl.deflate(outputByte);
                bos.write(outputByte, 0, len);
            }
            defl.end();
        } catch (Exception e) {
            throw e;
        } finally {
            bos.close();
        }
        return bos.toByteArray();
    }

    private static byte[] uncompress(byte[] inputByte) throws Exception {
        int len = 0;
        Inflater infl = new Inflater();
        infl.setInput(inputByte);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] outByte = new byte[1024];
        try {
            while (!infl.finished()) {
                len = infl.inflate(outByte);
                if (len == 0) {
                    break;
                }
                bos.write(outByte, 0, len);
            }
            infl.end();
        } catch (Exception e) {
            throw e;
        } finally {
            bos.close();
        }
        return bos.toByteArray();
    }

    private static void gen() {
        while (hexs.size() < hexLen) {
            String hex = genHexTmp();
            if (!hexs.contains(hex)) {
                hexs.add(hex);
            }
        }
    }

    private static String genHexTmp() {
        Random rnd = new Random();
        int len = HEX_TMP.length();
        List<Character> tmp = new ArrayList<>(17);
        String hex = "";
        while (tmp.size() < 16) {
            int index = rnd.nextInt(len);
            char c = HEX_TMP.charAt(index);
            if (!tmp.contains(c)) {
                tmp.add(c);
                hex += String.valueOf(c);
            }
        }
        tmp.clear();
        return hex;
    }
}
