/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
public class JaroWinkler
implements NormalizedStringSimilarity,
NormalizedStringDistance {
    private static final double DEFAULT_THRESHOLD = 0.7;
    private static final int THREE = 3;
    private static final double JW_COEF = 0.1;
    private final double threshold;

    public JaroWinkler() {
        this.threshold = 0.7;
    }

    public JaroWinkler(double threshold) {
        this.threshold = threshold;
    }

    public final double getThreshold() {
        return this.threshold;
    }

    public final double similarity(String s1, String s2) {
        double j;
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        int[] mtp = this.matches(s1, s2);
        float m = mtp[0];
        if (m == 0.0f) {
            return 0.0;
        }
        double jw = j = (double)((m / (float)s1.length() + m / (float)s2.length() + (m - (float)mtp[1]) / m) / 3.0f);
        if (j > this.getThreshold()) {
            jw = j + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)mtp[2] * (1.0 - j);
        }
        return jw;
    }

    public final double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }

    private int[] matches(String s1, String s2) {
        int i;
        String min;
        String max;
        if (s1.length() > s2.length()) {
            max = s1;
            min = s2;
        } else {
            max = s2;
            min = s1;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        block0: for (int mi = 0; mi < min.length(); ++mi) {
            char c1 = min.charAt(mi);
            int xn = Math.min(mi + range + 1, max.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block0;
            }
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        int si = 0;
        for (i = 0; i < min.length(); ++i) {
            if (matchIndexes[i] == -1) continue;
            ms1[si] = min.charAt(i);
            ++si;
        }
        si = 0;
        for (i = 0; i < max.length(); ++i) {
            if (!matchFlags[i]) continue;
            ms2[si] = max.charAt(i);
            ++si;
        }
        int transpositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < min.length() && s1.charAt(mi) == s2.charAt(mi); ++mi) {
            ++prefix;
        }
        return new int[]{matches, transpositions / 2, prefix, max.length()};
    }
}

