/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.Levenshtein;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import net.jcip.annotations.Immutable;

@Immutable
public class NormalizedLevenshtein
implements NormalizedStringDistance,
NormalizedStringSimilarity {
    private final Levenshtein l = new Levenshtein();

    public final double distance(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        int mLen = Math.max(s1.length(), s2.length());
        if (mLen == 0) {
            return 0.0;
        }
        return this.l.distance(s1, s2) / (double)mLen;
    }

    public final double similarity(String s1, String s2) {
        return 1.0 - this.distance(s1, s2);
    }
}

