package org.ccsds.moims.mo.malprototype.datatest.consumer;

/**
 * Consumer adapter for DataTest service.
 */
public abstract class DataTestAdapter extends org.ccsds.moims.mo.mal.consumer.MALInteractionAdapter
{
  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation setTestDataOffset.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void setTestDataOffsetAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation setTestDataOffset.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void setTestDataOffsetErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testData.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Element0 _Element0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Element _Element0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testData.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataBlob.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Blob0 _Blob0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataBlobResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Blob _Blob0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataBlob.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataBlobErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataBoolean.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Boolean0 _Boolean0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataBooleanResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Boolean _Boolean0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataBoolean.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataBooleanErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataDouble.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Double0 _Double0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataDoubleResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Double _Double0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataDouble.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataDoubleErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataDuration.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Duration0 _Duration0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataDurationResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Duration _Duration0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataDuration.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataDurationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataFineTime.
   * @param msgHeader msgHeader The header of the received message.
   * @param _FineTime0 _FineTime0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataFineTimeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.FineTime _FineTime0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataFineTime.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataFineTimeErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataFloat.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Float0 _Float0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataFloatResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Float _Float0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataFloat.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataFloatErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataIdentifier.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Identifier0 _Identifier0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataIdentifierResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Identifier _Identifier0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataIdentifier.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataIdentifierErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataInteger.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Integer0 _Integer0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataIntegerResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Integer _Integer0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataInteger.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataIntegerErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataLong.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Long0 _Long0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataLongResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Long _Long0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataLong.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataLongErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataOctet.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Byte0 _Byte0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataOctetResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Byte _Byte0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataOctet.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataOctetErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataShort.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Short0 _Short0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataShortResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Short _Short0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataShort.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataShortErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataString.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataStringResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataString.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataStringErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataTime.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Time0 _Time0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataTimeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Time _Time0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataTime.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataTimeErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataURI.
   * @param msgHeader msgHeader The header of the received message.
   * @param _URI0 _URI0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataURIResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.URI _URI0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataURI.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataURIErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataComposite.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Assertion0 _Assertion0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataCompositeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.malprototype.structures.Assertion _Assertion0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataComposite.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataCompositeErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataEnumeration.
   * @param msgHeader msgHeader The header of the received message.
   * @param _SessionType0 _SessionType0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataEnumerationResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.SessionType _SessionType0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataEnumeration.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataEnumerationErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataList.
   * @param msgHeader msgHeader The header of the received message.
   * @param _AssertionList0 _AssertionList0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataListResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.malprototype.structures.AssertionList _AssertionList0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataList.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataListErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataUInteger.
   * @param msgHeader msgHeader The header of the received message.
   * @param _UInteger0 _UInteger0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataUIntegerResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.UInteger _UInteger0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataUInteger.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataUIntegerErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataULong.
   * @param msgHeader msgHeader The header of the received message.
   * @param _ULong0 _ULong0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataULongResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.ULong _ULong0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataULong.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataULongErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataUOctet.
   * @param msgHeader msgHeader The header of the received message.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataUOctetResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataUOctet.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataUOctetErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testDataUShort.
   * @param msgHeader msgHeader The header of the received message.
   * @param _UShort0 _UShort0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataUShortResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.UShort _UShort0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testDataUShort.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testDataUShortErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testExplicitMultiReturn.
   * @param msgHeader msgHeader The header of the received message.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param _UShort1 _UShort1 Argument number 1 as defined by the service operation.
   * @param _UInteger2 _UInteger2 Argument number 2 as defined by the service operation.
   * @param _ULong3 _ULong3 Argument number 3 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testExplicitMultiReturnResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, org.ccsds.moims.mo.mal.structures.UShort _UShort1, org.ccsds.moims.mo.mal.structures.UInteger _UInteger2, org.ccsds.moims.mo.mal.structures.ULong _ULong3, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testExplicitMultiReturn.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testExplicitMultiReturnErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testAbstractMultiReturn.
   * @param msgHeader msgHeader The header of the received message.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param _UShort1 _UShort1 Argument number 1 as defined by the service operation.
   * @param _UInteger2 _UInteger2 Argument number 2 as defined by the service operation.
   * @param _Element3 _Element3 Argument number 3 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testAbstractMultiReturnResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, org.ccsds.moims.mo.mal.structures.UShort _UShort1, org.ccsds.moims.mo.mal.structures.UInteger _UInteger2, org.ccsds.moims.mo.mal.structures.Element _Element3, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testAbstractMultiReturn.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testAbstractMultiReturnErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testEmptyBodyResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testEmptyBodyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testMalAttribute.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Attribute0 _Attribute0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalAttributeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Attribute _Attribute0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testMalAttribute.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalAttributeErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testMalComposite.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Composite0 _Composite0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalCompositeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Composite _Composite0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testMalComposite.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalCompositeErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testAbstractComposite.
   * @param msgHeader msgHeader The header of the received message.
   * @param _TestPublish0 _TestPublish0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testAbstractCompositeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish _TestPublish0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testAbstractComposite.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testAbstractCompositeErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testMalAttributeList.
   * @param msgHeader msgHeader The header of the received message.
   * @param _AttributeList0 _AttributeList0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalAttributeListResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.AttributeList _AttributeList0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testMalAttributeList.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalAttributeListErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testMalElementList.
   * @param msgHeader msgHeader The header of the received message.
   * @param _ElementList0 _ElementList0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalElementListResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.ElementList _ElementList0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testMalElementList.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalElementListErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testMalCompositeList.
   * @param msgHeader msgHeader The header of the received message.
   * @param _CompositeList0 _CompositeList0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalCompositeListResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.CompositeList _CompositeList0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testMalCompositeList.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMalCompositeListErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testAbstractCompositeList.
   * @param msgHeader msgHeader The header of the received message.
   * @param _TestPublishList0 _TestPublishList0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testAbstractCompositeListResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishList _TestPublishList0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testAbstractCompositeList.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testAbstractCompositeListErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void submitAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._SETTESTDATAOFFSET_OP_NUMBER:
        setTestDataOffsetAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void submitErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._SETTESTDATAOFFSET_OP_NUMBER:
        setTestDataOffsetErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void requestResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALMessageBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATA_OP_NUMBER:
        testDataResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATABLOB_OP_NUMBER:
        testDataBlobResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Blob) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Blob()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATABOOLEAN_OP_NUMBER:
        testDataBooleanResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Boolean.FALSE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Boolean.FALSE))).getBooleanValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATADOUBLE_OP_NUMBER:
        testDataDoubleResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Double.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Double.MAX_VALUE))).getDoubleValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATADURATION_OP_NUMBER:
        testDataDurationResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Duration) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Duration()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAFINETIME_OP_NUMBER:
        testDataFineTimeResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.FineTime) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.FineTime()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAFLOAT_OP_NUMBER:
        testDataFloatResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Float.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Float.MAX_VALUE))).getFloatValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAIDENTIFIER_OP_NUMBER:
        testDataIdentifierResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAINTEGER_OP_NUMBER:
        testDataIntegerResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE))).getIntegerValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATALONG_OP_NUMBER:
        testDataLongResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Long.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Long.MAX_VALUE))).getLongValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAOCTET_OP_NUMBER:
        testDataOctetResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Byte.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Byte.MAX_VALUE))).getOctetValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATASHORT_OP_NUMBER:
        testDataShortResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Short.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Short.MAX_VALUE))).getShortValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATASTRING_OP_NUMBER:
        testDataStringResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATATIME_OP_NUMBER:
        testDataTimeResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Time) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Time()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAURI_OP_NUMBER:
        testDataURIResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.URI) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.URI()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATACOMPOSITE_OP_NUMBER:
        testDataCompositeResponseReceived(msgHeader, (org.ccsds.moims.mo.malprototype.structures.Assertion) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.structures.Assertion()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAENUMERATION_OP_NUMBER:
        testDataEnumerationResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.SessionType) body.getBodyElement(0, org.ccsds.moims.mo.mal.structures.SessionType.LIVE), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATALIST_OP_NUMBER:
        testDataListResponseReceived(msgHeader, (org.ccsds.moims.mo.malprototype.structures.AssertionList) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.structures.AssertionList()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUINTEGER_OP_NUMBER:
        testDataUIntegerResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.UInteger) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UInteger()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAULONG_OP_NUMBER:
        testDataULongResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.ULong) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.ULong()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUOCTET_OP_NUMBER:
        testDataUOctetResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.UOctet) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUSHORT_OP_NUMBER:
        testDataUShortResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.UShort) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UShort()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTEXPLICITMULTIRETURN_OP_NUMBER:
        testExplicitMultiReturnResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.UOctet) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet()), (org.ccsds.moims.mo.mal.structures.UShort) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UShort()), (org.ccsds.moims.mo.mal.structures.UInteger) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.UInteger()), (org.ccsds.moims.mo.mal.structures.ULong) body.getBodyElement(3, new org.ccsds.moims.mo.mal.structures.ULong()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTMULTIRETURN_OP_NUMBER:
        testAbstractMultiReturnResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.UOctet) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet()), (org.ccsds.moims.mo.mal.structures.UShort) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UShort()), (org.ccsds.moims.mo.mal.structures.UInteger) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.UInteger()), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(3, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTEMPTYBODY_OP_NUMBER:
        testEmptyBodyResponseReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALATTRIBUTE_OP_NUMBER:
        testMalAttributeResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Attribute) body.getBodyElement(0, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALCOMPOSITE_OP_NUMBER:
        testMalCompositeResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Composite) body.getBodyElement(0, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTCOMPOSITE_OP_NUMBER:
        testAbstractCompositeResponseReceived(msgHeader, (org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish) body.getBodyElement(0, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALATTRIBUTELIST_OP_NUMBER:
        testMalAttributeListResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.AttributeList) body.getBodyElement(0, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALELEMENTLIST_OP_NUMBER:
        testMalElementListResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.ElementList) body.getBodyElement(0, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALCOMPOSITELIST_OP_NUMBER:
        testMalCompositeListResponseReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.CompositeList) body.getBodyElement(0, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTCOMPOSITELIST_OP_NUMBER:
        testAbstractCompositeListResponseReceived(msgHeader, (org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishList) body.getBodyElement(0, null), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void requestErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATA_OP_NUMBER:
        testDataErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATABLOB_OP_NUMBER:
        testDataBlobErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATABOOLEAN_OP_NUMBER:
        testDataBooleanErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATADOUBLE_OP_NUMBER:
        testDataDoubleErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATADURATION_OP_NUMBER:
        testDataDurationErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAFINETIME_OP_NUMBER:
        testDataFineTimeErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAFLOAT_OP_NUMBER:
        testDataFloatErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAIDENTIFIER_OP_NUMBER:
        testDataIdentifierErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAINTEGER_OP_NUMBER:
        testDataIntegerErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATALONG_OP_NUMBER:
        testDataLongErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAOCTET_OP_NUMBER:
        testDataOctetErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATASHORT_OP_NUMBER:
        testDataShortErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATASTRING_OP_NUMBER:
        testDataStringErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATATIME_OP_NUMBER:
        testDataTimeErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAURI_OP_NUMBER:
        testDataURIErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATACOMPOSITE_OP_NUMBER:
        testDataCompositeErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAENUMERATION_OP_NUMBER:
        testDataEnumerationErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATALIST_OP_NUMBER:
        testDataListErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUINTEGER_OP_NUMBER:
        testDataUIntegerErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAULONG_OP_NUMBER:
        testDataULongErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUOCTET_OP_NUMBER:
        testDataUOctetErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUSHORT_OP_NUMBER:
        testDataUShortErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTEXPLICITMULTIRETURN_OP_NUMBER:
        testExplicitMultiReturnErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTMULTIRETURN_OP_NUMBER:
        testAbstractMultiReturnErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTEMPTYBODY_OP_NUMBER:
        testEmptyBodyErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALATTRIBUTE_OP_NUMBER:
        testMalAttributeErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALCOMPOSITE_OP_NUMBER:
        testMalCompositeErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTCOMPOSITE_OP_NUMBER:
        testAbstractCompositeErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALATTRIBUTELIST_OP_NUMBER:
        testMalAttributeListErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALELEMENTLIST_OP_NUMBER:
        testMalElementListErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALCOMPOSITELIST_OP_NUMBER:
        testMalCompositeListErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTCOMPOSITELIST_OP_NUMBER:
        testAbstractCompositeListErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

}
