package org.ccsds.moims.mo.malprototype.datatest.consumer;

/**
 * Consumer stub for DataTest service.
 */
public class DataTestStub implements org.ccsds.moims.mo.malprototype.datatest.consumer.DataTest
{
  private final org.ccsds.moims.mo.mal.consumer.MALConsumer consumer;
  /**
   * Wraps a MALconsumer connection with service specific methods that map from the high level service API to the generic MAL API.
   * @param consumer consumer The MALConsumer to use in this stub.
   */
  public DataTestStub(org.ccsds.moims.mo.mal.consumer.MALConsumer consumer)
  {
    this.consumer = consumer;
  }

  /**
   * Returns the internal MAL consumer object used for sending of messages from this interface.
   * @return The MAL consumer object.
   */
  public org.ccsds.moims.mo.mal.consumer.MALConsumer getConsumer()
  {
    return consumer;
  }

  /**
   * This operation sets the index into the test list for the testData operation. Passing non positive values resets it to the start of the list.
   * @param _Integer0 _Integer0 Argument number 0 as defined by the service operation.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void setTestDataOffset(Integer _Integer0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.submit(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.SETTESTDATAOFFSET_OP, (_Integer0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Integer0));
  }

  /**
   * Asynchronous version of method setTestDataOffset.
   * @param _Integer0 _Integer0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncSetTestDataOffset(Integer _Integer0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncSubmit(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.SETTESTDATAOFFSET_OP, adapter, (_Integer0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Integer0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueSetTestDataOffset(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.SETTESTDATAOFFSET_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * The 'testData' operation allows a consumer to check that a data is correctly decoded on the provider side. The provider needs to statically know the list of data that the consumer is going to send. The consumer selects the data in the same order as the list and calls the operation 'testData'. The provider keeps the index of the currently selected data from the static list. When the operation 'testData' is called, the provider checks that the received data is equal to the selected data from the list. If the equality test fails, then the error DATA_ERROR is raised otherwise the provider returns the sent data.
   * @param _Element0 _Element0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.Element testData(org.ccsds.moims.mo.mal.structures.Element _Element0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATA_OP, _Element0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.mal.structures.Element) body0;
  }

  /**
   * Asynchronous version of method testData.
   * @param _Element0 _Element0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestData(org.ccsds.moims.mo.mal.structures.Element _Element0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATA_OP, adapter, _Element0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestData(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATA_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Blob type can be sent and received explicitly.
   * @param _Blob0 _Blob0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.Blob testDataBlob(org.ccsds.moims.mo.mal.structures.Blob _Blob0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATABLOB_OP, _Blob0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Blob());
    return (org.ccsds.moims.mo.mal.structures.Blob) body0;
  }

  /**
   * Asynchronous version of method testDataBlob.
   * @param _Blob0 _Blob0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataBlob(org.ccsds.moims.mo.mal.structures.Blob _Blob0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATABLOB_OP, adapter, _Blob0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataBlob(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATABLOB_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Boolean type can be sent and received explicitly.
   * @param _Boolean0 _Boolean0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public Boolean testDataBoolean(Boolean _Boolean0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATABOOLEAN_OP, (_Boolean0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Boolean0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Boolean.FALSE));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getBooleanValue();
  }

  /**
   * Asynchronous version of method testDataBoolean.
   * @param _Boolean0 _Boolean0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataBoolean(Boolean _Boolean0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATABOOLEAN_OP, adapter, (_Boolean0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Boolean0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataBoolean(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATABOOLEAN_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Double type can be sent and received explicitly.
   * @param _Double0 _Double0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public Double testDataDouble(Double _Double0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATADOUBLE_OP, (_Double0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Double0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Double.MAX_VALUE));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getDoubleValue();
  }

  /**
   * Asynchronous version of method testDataDouble.
   * @param _Double0 _Double0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataDouble(Double _Double0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATADOUBLE_OP, adapter, (_Double0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Double0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataDouble(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATADOUBLE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Duration type can be sent and received explicitly.
   * @param _Duration0 _Duration0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.Duration testDataDuration(org.ccsds.moims.mo.mal.structures.Duration _Duration0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATADURATION_OP, _Duration0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Duration());
    return (org.ccsds.moims.mo.mal.structures.Duration) body0;
  }

  /**
   * Asynchronous version of method testDataDuration.
   * @param _Duration0 _Duration0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataDuration(org.ccsds.moims.mo.mal.structures.Duration _Duration0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATADURATION_OP, adapter, _Duration0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataDuration(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATADURATION_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic FineTime type can be sent and received explicitly.
   * @param _FineTime0 _FineTime0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.FineTime testDataFineTime(org.ccsds.moims.mo.mal.structures.FineTime _FineTime0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAFINETIME_OP, _FineTime0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.FineTime());
    return (org.ccsds.moims.mo.mal.structures.FineTime) body0;
  }

  /**
   * Asynchronous version of method testDataFineTime.
   * @param _FineTime0 _FineTime0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataFineTime(org.ccsds.moims.mo.mal.structures.FineTime _FineTime0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAFINETIME_OP, adapter, _FineTime0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataFineTime(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAFINETIME_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Float type can be sent and received explicitly.
   * @param _Float0 _Float0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public Float testDataFloat(Float _Float0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAFLOAT_OP, (_Float0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Float0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Float.MAX_VALUE));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getFloatValue();
  }

  /**
   * Asynchronous version of method testDataFloat.
   * @param _Float0 _Float0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataFloat(Float _Float0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAFLOAT_OP, adapter, (_Float0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Float0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataFloat(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAFLOAT_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Identifier type can be sent and received explicitly.
   * @param _Identifier0 _Identifier0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.Identifier testDataIdentifier(org.ccsds.moims.mo.mal.structures.Identifier _Identifier0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAIDENTIFIER_OP, _Identifier0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier());
    return (org.ccsds.moims.mo.mal.structures.Identifier) body0;
  }

  /**
   * Asynchronous version of method testDataIdentifier.
   * @param _Identifier0 _Identifier0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataIdentifier(org.ccsds.moims.mo.mal.structures.Identifier _Identifier0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAIDENTIFIER_OP, adapter, _Identifier0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataIdentifier(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAIDENTIFIER_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Integer type can be sent and received explicitly.
   * @param _Integer0 _Integer0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public Integer testDataInteger(Integer _Integer0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAINTEGER_OP, (_Integer0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Integer0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getIntegerValue();
  }

  /**
   * Asynchronous version of method testDataInteger.
   * @param _Integer0 _Integer0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataInteger(Integer _Integer0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAINTEGER_OP, adapter, (_Integer0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Integer0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataInteger(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAINTEGER_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Long type can be sent and received explicitly.
   * @param _Long0 _Long0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public Long testDataLong(Long _Long0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATALONG_OP, (_Long0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Long0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Long.MAX_VALUE));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getLongValue();
  }

  /**
   * Asynchronous version of method testDataLong.
   * @param _Long0 _Long0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataLong(Long _Long0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATALONG_OP, adapter, (_Long0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Long0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataLong(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATALONG_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Octet type can be sent and received explicitly.
   * @param _Byte0 _Byte0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public Byte testDataOctet(Byte _Byte0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAOCTET_OP, (_Byte0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Byte0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Byte.MAX_VALUE));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getOctetValue();
  }

  /**
   * Asynchronous version of method testDataOctet.
   * @param _Byte0 _Byte0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataOctet(Byte _Byte0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAOCTET_OP, adapter, (_Byte0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Byte0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataOctet(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAOCTET_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Short type can be sent and received explicitly.
   * @param _Short0 _Short0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public Short testDataShort(Short _Short0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATASHORT_OP, (_Short0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Short0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Short.MAX_VALUE));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getShortValue();
  }

  /**
   * Asynchronous version of method testDataShort.
   * @param _Short0 _Short0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataShort(Short _Short0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATASHORT_OP, adapter, (_Short0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_Short0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataShort(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATASHORT_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic String type can be sent and received explicitly.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public String testDataString(String _String0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATASTRING_OP, (_String0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_String0));
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""));
    return (body0 == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body0).getStringValue();
  }

  /**
   * Asynchronous version of method testDataString.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataString(String _String0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATASTRING_OP, adapter, (_String0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_String0));
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataString(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATASTRING_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic Time type can be sent and received explicitly.
   * @param _Time0 _Time0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.Time testDataTime(org.ccsds.moims.mo.mal.structures.Time _Time0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATATIME_OP, _Time0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Time());
    return (org.ccsds.moims.mo.mal.structures.Time) body0;
  }

  /**
   * Asynchronous version of method testDataTime.
   * @param _Time0 _Time0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataTime(org.ccsds.moims.mo.mal.structures.Time _Time0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATATIME_OP, adapter, _Time0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataTime(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATATIME_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic URI type can be sent and received explicitly.
   * @param _URI0 _URI0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.URI testDataURI(org.ccsds.moims.mo.mal.structures.URI _URI0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAURI_OP, _URI0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.URI());
    return (org.ccsds.moims.mo.mal.structures.URI) body0;
  }

  /**
   * Asynchronous version of method testDataURI.
   * @param _URI0 _URI0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataURI(org.ccsds.moims.mo.mal.structures.URI _URI0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAURI_OP, adapter, _URI0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataURI(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAURI_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a composite type can be sent and received explicitly.
   * @param _Assertion0 _Assertion0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.malprototype.structures.Assertion testDataComposite(org.ccsds.moims.mo.malprototype.structures.Assertion _Assertion0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATACOMPOSITE_OP, _Assertion0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.structures.Assertion());
    return (org.ccsds.moims.mo.malprototype.structures.Assertion) body0;
  }

  /**
   * Asynchronous version of method testDataComposite.
   * @param _Assertion0 _Assertion0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataComposite(org.ccsds.moims.mo.malprototype.structures.Assertion _Assertion0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATACOMPOSITE_OP, adapter, _Assertion0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataComposite(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATACOMPOSITE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a enumeration type can be sent and received explicitly.
   * @param _SessionType0 _SessionType0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.SessionType testDataEnumeration(org.ccsds.moims.mo.mal.structures.SessionType _SessionType0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAENUMERATION_OP, _SessionType0);
    Object body0 = (Object) body.getBodyElement(0, org.ccsds.moims.mo.mal.structures.SessionType.LIVE);
    return (org.ccsds.moims.mo.mal.structures.SessionType) body0;
  }

  /**
   * Asynchronous version of method testDataEnumeration.
   * @param _SessionType0 _SessionType0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataEnumeration(org.ccsds.moims.mo.mal.structures.SessionType _SessionType0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAENUMERATION_OP, adapter, _SessionType0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataEnumeration(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAENUMERATION_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a list type can be sent and received explicitly.
   * @param _AssertionList0 _AssertionList0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.malprototype.structures.AssertionList testDataList(org.ccsds.moims.mo.malprototype.structures.AssertionList _AssertionList0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATALIST_OP, _AssertionList0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.structures.AssertionList());
    return (org.ccsds.moims.mo.malprototype.structures.AssertionList) body0;
  }

  /**
   * Asynchronous version of method testDataList.
   * @param _AssertionList0 _AssertionList0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataList(org.ccsds.moims.mo.malprototype.structures.AssertionList _AssertionList0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATALIST_OP, adapter, _AssertionList0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataList(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATALIST_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic UInteger type can be sent and received explicitly.
   * @param _UInteger0 _UInteger0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.UInteger testDataUInteger(org.ccsds.moims.mo.mal.structures.UInteger _UInteger0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUINTEGER_OP, _UInteger0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UInteger());
    return (org.ccsds.moims.mo.mal.structures.UInteger) body0;
  }

  /**
   * Asynchronous version of method testDataUInteger.
   * @param _UInteger0 _UInteger0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataUInteger(org.ccsds.moims.mo.mal.structures.UInteger _UInteger0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUINTEGER_OP, adapter, _UInteger0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataUInteger(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUINTEGER_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic ULong type can be sent and received explicitly.
   * @param _ULong0 _ULong0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.ULong testDataULong(org.ccsds.moims.mo.mal.structures.ULong _ULong0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAULONG_OP, _ULong0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.ULong());
    return (org.ccsds.moims.mo.mal.structures.ULong) body0;
  }

  /**
   * Asynchronous version of method testDataULong.
   * @param _ULong0 _ULong0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataULong(org.ccsds.moims.mo.mal.structures.ULong _ULong0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAULONG_OP, adapter, _ULong0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataULong(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAULONG_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic UOctet type can be sent and received explicitly.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.UOctet testDataUOctet(org.ccsds.moims.mo.mal.structures.UOctet _UOctet0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUOCTET_OP, _UOctet0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet());
    return (org.ccsds.moims.mo.mal.structures.UOctet) body0;
  }

  /**
   * Asynchronous version of method testDataUOctet.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataUOctet(org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUOCTET_OP, adapter, _UOctet0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataUOctet(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUOCTET_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a basic UShort type can be sent and received explicitly.
   * @param _UShort0 _UShort0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.UShort testDataUShort(org.ccsds.moims.mo.mal.structures.UShort _UShort0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUSHORT_OP, _UShort0);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UShort());
    return (org.ccsds.moims.mo.mal.structures.UShort) body0;
  }

  /**
   * Asynchronous version of method testDataUShort.
   * @param _UShort0 _UShort0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestDataUShort(org.ccsds.moims.mo.mal.structures.UShort _UShort0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUSHORT_OP, adapter, _UShort0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestDataUShort(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTDATAUSHORT_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that multiple types can be sent and received explicitly.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param _UShort1 _UShort1 Argument number 1 as defined by the service operation.
   * @param _UInteger2 _UInteger2 Argument number 2 as defined by the service operation.
   * @param _ULong3 _ULong3 Argument number 3 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.malprototype.datatest.body.TestExplicitMultiReturnResponse testExplicitMultiReturn(org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, org.ccsds.moims.mo.mal.structures.UShort _UShort1, org.ccsds.moims.mo.mal.structures.UInteger _UInteger2, org.ccsds.moims.mo.mal.structures.ULong _ULong3) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTEXPLICITMULTIRETURN_OP, _UOctet0, _UShort1, _UInteger2, _ULong3);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet());
    Object body1 = (Object) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UShort());
    Object body2 = (Object) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.UInteger());
    Object body3 = (Object) body.getBodyElement(3, new org.ccsds.moims.mo.mal.structures.ULong());
    return new org.ccsds.moims.mo.malprototype.datatest.body.TestExplicitMultiReturnResponse((org.ccsds.moims.mo.mal.structures.UOctet) body0, (org.ccsds.moims.mo.mal.structures.UShort) body1, (org.ccsds.moims.mo.mal.structures.UInteger) body2, (org.ccsds.moims.mo.mal.structures.ULong) body3);
  }

  /**
   * Asynchronous version of method testExplicitMultiReturn.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param _UShort1 _UShort1 Argument number 1 as defined by the service operation.
   * @param _UInteger2 _UInteger2 Argument number 2 as defined by the service operation.
   * @param _ULong3 _ULong3 Argument number 3 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestExplicitMultiReturn(org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, org.ccsds.moims.mo.mal.structures.UShort _UShort1, org.ccsds.moims.mo.mal.structures.UInteger _UInteger2, org.ccsds.moims.mo.mal.structures.ULong _ULong3, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTEXPLICITMULTIRETURN_OP, adapter, _UOctet0, _UShort1, _UInteger2, _ULong3);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestExplicitMultiReturn(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTEXPLICITMULTIRETURN_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that multiple types with a final abstract type can be sent and received explicitly.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param _UShort1 _UShort1 Argument number 1 as defined by the service operation.
   * @param _UInteger2 _UInteger2 Argument number 2 as defined by the service operation.
   * @param _Element3 _Element3 Argument number 3 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.malprototype.datatest.body.TestAbstractMultiReturnResponse testAbstractMultiReturn(org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, org.ccsds.moims.mo.mal.structures.UShort _UShort1, org.ccsds.moims.mo.mal.structures.UInteger _UInteger2, org.ccsds.moims.mo.mal.structures.Element _Element3) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTMULTIRETURN_OP, _UOctet0, _UShort1, _UInteger2, _Element3);
    Object body0 = (Object) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet());
    Object body1 = (Object) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UShort());
    Object body2 = (Object) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.UInteger());
    Object body3 = (Object) body.getBodyElement(3, null);
    return new org.ccsds.moims.mo.malprototype.datatest.body.TestAbstractMultiReturnResponse((org.ccsds.moims.mo.mal.structures.UOctet) body0, (org.ccsds.moims.mo.mal.structures.UShort) body1, (org.ccsds.moims.mo.mal.structures.UInteger) body2, (org.ccsds.moims.mo.mal.structures.Element) body3);
  }

  /**
   * Asynchronous version of method testAbstractMultiReturn.
   * @param _UOctet0 _UOctet0 Argument number 0 as defined by the service operation.
   * @param _UShort1 _UShort1 Argument number 1 as defined by the service operation.
   * @param _UInteger2 _UInteger2 Argument number 2 as defined by the service operation.
   * @param _Element3 _Element3 Argument number 3 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestAbstractMultiReturn(org.ccsds.moims.mo.mal.structures.UOctet _UOctet0, org.ccsds.moims.mo.mal.structures.UShort _UShort1, org.ccsds.moims.mo.mal.structures.UInteger _UInteger2, org.ccsds.moims.mo.mal.structures.Element _Element3, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTMULTIRETURN_OP, adapter, _UOctet0, _UShort1, _UInteger2, _Element3);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestAbstractMultiReturn(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTMULTIRETURN_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that an empty body can be sent and received explicitly.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void testEmptyBody() throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTEMPTYBODY_OP, (Object[]) null);
  }

  /**
   * Asynchronous version of method testEmptyBody.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestEmptyBody(org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTEMPTYBODY_OP, adapter, (Object[]) null);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestEmptyBody(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTEMPTYBODY_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a MAL::Attribute can be sent and received explicitly.
   * @param _Attribute0 _Attribute0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.Attribute testMalAttribute(org.ccsds.moims.mo.mal.structures.Attribute _Attribute0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALATTRIBUTE_OP, _Attribute0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.mal.structures.Attribute) body0;
  }

  /**
   * Asynchronous version of method testMalAttribute.
   * @param _Attribute0 _Attribute0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestMalAttribute(org.ccsds.moims.mo.mal.structures.Attribute _Attribute0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALATTRIBUTE_OP, adapter, _Attribute0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestMalAttribute(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALATTRIBUTE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a MAL::Composite can be sent and received explicitly.
   * @param _Composite0 _Composite0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.Composite testMalComposite(org.ccsds.moims.mo.mal.structures.Composite _Composite0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALCOMPOSITE_OP, _Composite0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.mal.structures.Composite) body0;
  }

  /**
   * Asynchronous version of method testMalComposite.
   * @param _Composite0 _Composite0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestMalComposite(org.ccsds.moims.mo.mal.structures.Composite _Composite0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALCOMPOSITE_OP, adapter, _Composite0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestMalComposite(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALCOMPOSITE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that an abstract Composite can be sent and received explicitly.
   * @param _TestPublish0 _TestPublish0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish testAbstractComposite(org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish _TestPublish0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTCOMPOSITE_OP, _TestPublish0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish) body0;
  }

  /**
   * Asynchronous version of method testAbstractComposite.
   * @param _TestPublish0 _TestPublish0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestAbstractComposite(org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish _TestPublish0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTCOMPOSITE_OP, adapter, _TestPublish0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestAbstractComposite(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTCOMPOSITE_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a list of MAL::Attribute can be sent and received explicitly.
   * @param _AttributeList0 _AttributeList0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.AttributeList testMalAttributeList(org.ccsds.moims.mo.mal.structures.AttributeList _AttributeList0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALATTRIBUTELIST_OP, _AttributeList0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.mal.structures.AttributeList) body0;
  }

  /**
   * Asynchronous version of method testMalAttributeList.
   * @param _AttributeList0 _AttributeList0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestMalAttributeList(org.ccsds.moims.mo.mal.structures.AttributeList _AttributeList0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALATTRIBUTELIST_OP, adapter, _AttributeList0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestMalAttributeList(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALATTRIBUTELIST_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a list of MAL::Element can be sent and received explicitly.
   * @param _ElementList0 _ElementList0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.ElementList testMalElementList(org.ccsds.moims.mo.mal.structures.ElementList _ElementList0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALELEMENTLIST_OP, _ElementList0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.mal.structures.ElementList) body0;
  }

  /**
   * Asynchronous version of method testMalElementList.
   * @param _ElementList0 _ElementList0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestMalElementList(org.ccsds.moims.mo.mal.structures.ElementList _ElementList0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALELEMENTLIST_OP, adapter, _ElementList0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestMalElementList(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALELEMENTLIST_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a list of MAL::Composite can be sent and received explicitly.
   * @param _CompositeList0 _CompositeList0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.structures.CompositeList testMalCompositeList(org.ccsds.moims.mo.mal.structures.CompositeList _CompositeList0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALCOMPOSITELIST_OP, _CompositeList0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.mal.structures.CompositeList) body0;
  }

  /**
   * Asynchronous version of method testMalCompositeList.
   * @param _CompositeList0 _CompositeList0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestMalCompositeList(org.ccsds.moims.mo.mal.structures.CompositeList _CompositeList0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALCOMPOSITELIST_OP, adapter, _CompositeList0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestMalCompositeList(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTMALCOMPOSITELIST_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

  /**
   * This operation checks that a list of abstract composite can be sent and received explicitly.
   * @param _TestPublishList0 _TestPublishList0 Argument number 0 as defined by the service operation.
   * @return The return value of the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishList testAbstractCompositeList(org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishList _TestPublishList0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    org.ccsds.moims.mo.mal.transport.MALMessageBody body = consumer.request(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTCOMPOSITELIST_OP, _TestPublishList0);
    Object body0 = (Object) body.getBodyElement(0, null);
    return (org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishList) body0;
  }

  /**
   * Asynchronous version of method testAbstractCompositeList.
   * @param _TestPublishList0 _TestPublishList0 Argument number 0 as defined by the service operation.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @return the MAL message sent to initiate the interaction.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage asyncTestAbstractCompositeList(org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishList _TestPublishList0, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return consumer.asyncRequest(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTCOMPOSITELIST_OP, adapter, _TestPublishList0);
  }

  /**
   * Continues a previously started interaction.
   * @param lastInteractionStage lastInteractionStage The last stage of the interaction to continue.
   * @param initiationTimestamp initiationTimestamp Timestamp of the interaction initiation message.
   * @param transactionId transactionId Transaction identifier of the interaction to continue.
   * @param adapter adapter Listener in charge of receiving the messages from the service provider.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void continueTestAbstractCompositeList(org.ccsds.moims.mo.mal.structures.UOctet lastInteractionStage, org.ccsds.moims.mo.mal.structures.Time initiationTimestamp, Long transactionId, org.ccsds.moims.mo.malprototype.datatest.consumer.DataTestAdapter adapter) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    consumer.continueInteraction(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.TESTABSTRACTCOMPOSITELIST_OP, lastInteractionStage, initiationTimestamp, transactionId, adapter);
  }

}
