package org.ccsds.moims.mo.malprototype.datatest.provider;

/**
 * Provider Inheritance skeleton for DataTestInheritanceSkeleton service.
 */
public abstract class DataTestInheritanceSkeleton implements org.ccsds.moims.mo.mal.provider.MALInteractionHandler, org.ccsds.moims.mo.malprototype.datatest.provider.DataTestSkeleton, org.ccsds.moims.mo.malprototype.datatest.provider.DataTestHandler
{
  private org.ccsds.moims.mo.mal.provider.MALProviderSet providerSet = new org.ccsds.moims.mo.mal.provider.MALProviderSet(org.ccsds.moims.mo.malprototype.datatest.DataTestHelper.DATATEST_SERVICE);
  /**
   * Implements the setSkeleton method of the handler interface but does nothing as this is the skeleton.
   * @param skeleton skeleton Not used in the inheritance pattern (the skeleton is 'this'.
   */
  public void setSkeleton(org.ccsds.moims.mo.malprototype.datatest.provider.DataTestSkeleton skeleton)
  {
    // Not used in the inheritance pattern (the skeleton is 'this');
  }

  /**
   * Adds the supplied MAL provider to the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malInitialize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.addProvider(provider);
  }

  /**
   * Removes the supplied MAL provider from the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malFinalize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.removeProvider(provider);
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSend(org.ccsds.moims.mo.mal.provider.MALInteraction interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSubmit(org.ccsds.moims.mo.mal.provider.MALSubmit interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._SETTESTDATAOFFSET_OP_NUMBER:
        setTestDataOffset((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE))).getIntegerValue(), interaction);
        interaction.sendAcknowledgement();
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleRequest(org.ccsds.moims.mo.mal.provider.MALRequest interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATA_OP_NUMBER:
        interaction.sendResponse(testData((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATABLOB_OP_NUMBER:
        interaction.sendResponse(testDataBlob((org.ccsds.moims.mo.mal.structures.Blob) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Blob()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATABOOLEAN_OP_NUMBER:
        Boolean testDataBooleanRt = testDataBoolean((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Boolean.FALSE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Boolean.FALSE))).getBooleanValue(), interaction);
        interaction.sendResponse((testDataBooleanRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataBooleanRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATADOUBLE_OP_NUMBER:
        Double testDataDoubleRt = testDataDouble((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Double.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Double.MAX_VALUE))).getDoubleValue(), interaction);
        interaction.sendResponse((testDataDoubleRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataDoubleRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATADURATION_OP_NUMBER:
        interaction.sendResponse(testDataDuration((org.ccsds.moims.mo.mal.structures.Duration) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Duration()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAFINETIME_OP_NUMBER:
        interaction.sendResponse(testDataFineTime((org.ccsds.moims.mo.mal.structures.FineTime) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.FineTime()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAFLOAT_OP_NUMBER:
        Float testDataFloatRt = testDataFloat((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Float.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Float.MAX_VALUE))).getFloatValue(), interaction);
        interaction.sendResponse((testDataFloatRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataFloatRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAIDENTIFIER_OP_NUMBER:
        interaction.sendResponse(testDataIdentifier((org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAINTEGER_OP_NUMBER:
        Integer testDataIntegerRt = testDataInteger((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE))).getIntegerValue(), interaction);
        interaction.sendResponse((testDataIntegerRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataIntegerRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATALONG_OP_NUMBER:
        Long testDataLongRt = testDataLong((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Long.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Long.MAX_VALUE))).getLongValue(), interaction);
        interaction.sendResponse((testDataLongRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataLongRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAOCTET_OP_NUMBER:
        Byte testDataOctetRt = testDataOctet((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Byte.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Byte.MAX_VALUE))).getOctetValue(), interaction);
        interaction.sendResponse((testDataOctetRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataOctetRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATASHORT_OP_NUMBER:
        Short testDataShortRt = testDataShort((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Short.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Short.MAX_VALUE))).getShortValue(), interaction);
        interaction.sendResponse((testDataShortRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataShortRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATASTRING_OP_NUMBER:
        String testDataStringRt = testDataString((body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), interaction);
        interaction.sendResponse((testDataStringRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(testDataStringRt));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATATIME_OP_NUMBER:
        interaction.sendResponse(testDataTime((org.ccsds.moims.mo.mal.structures.Time) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Time()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAURI_OP_NUMBER:
        interaction.sendResponse(testDataURI((org.ccsds.moims.mo.mal.structures.URI) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.URI()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATACOMPOSITE_OP_NUMBER:
        interaction.sendResponse(testDataComposite((org.ccsds.moims.mo.malprototype.structures.Assertion) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.structures.Assertion()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAENUMERATION_OP_NUMBER:
        interaction.sendResponse(testDataEnumeration((org.ccsds.moims.mo.mal.structures.SessionType) body.getBodyElement(0, org.ccsds.moims.mo.mal.structures.SessionType.LIVE), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATALIST_OP_NUMBER:
        interaction.sendResponse(testDataList((org.ccsds.moims.mo.malprototype.structures.AssertionList) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.structures.AssertionList()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUINTEGER_OP_NUMBER:
        interaction.sendResponse(testDataUInteger((org.ccsds.moims.mo.mal.structures.UInteger) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UInteger()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAULONG_OP_NUMBER:
        interaction.sendResponse(testDataULong((org.ccsds.moims.mo.mal.structures.ULong) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.ULong()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUOCTET_OP_NUMBER:
        interaction.sendResponse(testDataUOctet((org.ccsds.moims.mo.mal.structures.UOctet) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTDATAUSHORT_OP_NUMBER:
        interaction.sendResponse(testDataUShort((org.ccsds.moims.mo.mal.structures.UShort) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UShort()), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTEXPLICITMULTIRETURN_OP_NUMBER:
        org.ccsds.moims.mo.malprototype.datatest.body.TestExplicitMultiReturnResponse testExplicitMultiReturnRt = testExplicitMultiReturn((org.ccsds.moims.mo.mal.structures.UOctet) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet()), (org.ccsds.moims.mo.mal.structures.UShort) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UShort()), (org.ccsds.moims.mo.mal.structures.UInteger) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.UInteger()), (org.ccsds.moims.mo.mal.structures.ULong) body.getBodyElement(3, new org.ccsds.moims.mo.mal.structures.ULong()), interaction);
        interaction.sendResponse(testExplicitMultiReturnRt.getBodyElement0(), testExplicitMultiReturnRt.getBodyElement1(), testExplicitMultiReturnRt.getBodyElement2(), testExplicitMultiReturnRt.getBodyElement3());
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTMULTIRETURN_OP_NUMBER:
        org.ccsds.moims.mo.malprototype.datatest.body.TestAbstractMultiReturnResponse testAbstractMultiReturnRt = testAbstractMultiReturn((org.ccsds.moims.mo.mal.structures.UOctet) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.UOctet()), (org.ccsds.moims.mo.mal.structures.UShort) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UShort()), (org.ccsds.moims.mo.mal.structures.UInteger) body.getBodyElement(2, new org.ccsds.moims.mo.mal.structures.UInteger()), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(3, null), interaction);
        interaction.sendResponse(testAbstractMultiReturnRt.getBodyElement0(), testAbstractMultiReturnRt.getBodyElement1(), testAbstractMultiReturnRt.getBodyElement2(), testAbstractMultiReturnRt.getBodyElement3());
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTEMPTYBODY_OP_NUMBER:
        testEmptyBody(interaction);
        interaction.sendResponse();
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALATTRIBUTE_OP_NUMBER:
        interaction.sendResponse(testMalAttribute((org.ccsds.moims.mo.mal.structures.Attribute) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALCOMPOSITE_OP_NUMBER:
        interaction.sendResponse(testMalComposite((org.ccsds.moims.mo.mal.structures.Composite) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTCOMPOSITE_OP_NUMBER:
        interaction.sendResponse(testAbstractComposite((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublish) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALATTRIBUTELIST_OP_NUMBER:
        interaction.sendResponse(testMalAttributeList((org.ccsds.moims.mo.mal.structures.AttributeList) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALELEMENTLIST_OP_NUMBER:
        interaction.sendResponse(testMalElementList((org.ccsds.moims.mo.mal.structures.ElementList) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTMALCOMPOSITELIST_OP_NUMBER:
        interaction.sendResponse(testMalCompositeList((org.ccsds.moims.mo.mal.structures.CompositeList) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.datatest.DataTestHelper._TESTABSTRACTCOMPOSITELIST_OP_NUMBER:
        interaction.sendResponse(testAbstractCompositeList((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishList) body.getBodyElement(0, null), interaction));
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleInvoke(org.ccsds.moims.mo.mal.provider.MALInvoke interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleProgress(org.ccsds.moims.mo.mal.provider.MALProgress interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

}
