package org.ccsds.moims.mo.malprototype.errortest.provider;

/**
 * Provider Inheritance skeleton for ErrorTestInheritanceSkeleton service.
 */
public abstract class ErrorTestInheritanceSkeleton implements org.ccsds.moims.mo.mal.provider.MALInteractionHandler, org.ccsds.moims.mo.malprototype.errortest.provider.ErrorTestSkeleton, org.ccsds.moims.mo.malprototype.errortest.provider.ErrorTestHandler
{
  private org.ccsds.moims.mo.mal.provider.MALProviderSet providerSet = new org.ccsds.moims.mo.mal.provider.MALProviderSet(org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper.ERRORTEST_SERVICE);
  /**
   * Implements the setSkeleton method of the handler interface but does nothing as this is the skeleton.
   * @param skeleton skeleton Not used in the inheritance pattern (the skeleton is 'this'.
   */
  public void setSkeleton(org.ccsds.moims.mo.malprototype.errortest.provider.ErrorTestSkeleton skeleton)
  {
    // Not used in the inheritance pattern (the skeleton is 'this');
  }

  /**
   * Adds the supplied MAL provider to the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malInitialize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.addProvider(provider);
  }

  /**
   * Removes the supplied MAL provider from the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malFinalize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.removeProvider(provider);
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSend(org.ccsds.moims.mo.mal.provider.MALInteraction interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSubmit(org.ccsds.moims.mo.mal.provider.MALSubmit interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleRequest(org.ccsds.moims.mo.mal.provider.MALRequest interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTDELIVERYFAILED_OP_NUMBER:
        interaction.sendResponse(testDeliveryFailed((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTDELIVERYTIMEDOUT_OP_NUMBER:
        interaction.sendResponse(testDeliveryTimedout((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTDELIVERYDELAYED_OP_NUMBER:
        interaction.sendResponse(testDeliveryDelayed((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTDESTINATIONUNKNOWN_OP_NUMBER:
        interaction.sendResponse(testDestinationUnknown((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTDESTINATIONTRANSIENT_OP_NUMBER:
        interaction.sendResponse(testDestinationTransient((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTDESTINATIONLOST_OP_NUMBER:
        interaction.sendResponse(testDestinationLost((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTENCRYPTIONFAIL_OP_NUMBER:
        interaction.sendResponse(testEncryptionFail((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTUNSUPPORTEDAREA_OP_NUMBER:
        interaction.sendResponse(testUnsupportedArea((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTUNSUPPORTEDOPERATION_OP_NUMBER:
        interaction.sendResponse(testUnsupportedOperation((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTUNSUPPORTEDVERSION_OP_NUMBER:
        interaction.sendResponse(testUnsupportedVersion((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTBADENCODING_OP_NUMBER:
        interaction.sendResponse(testBadEncoding((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTUNKNOWN_OP_NUMBER:
        interaction.sendResponse(testUnknown((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTAUTHENTICATIONFAILURE_OP_NUMBER:
        interaction.sendResponse(testAuthenticationFailure((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.errortest.ErrorTestHelper._TESTAUTHORIZATIONFAILURE_OP_NUMBER:
        interaction.sendResponse(testAuthorizationFailure((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleInvoke(org.ccsds.moims.mo.mal.provider.MALInvoke interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleProgress(org.ccsds.moims.mo.mal.provider.MALProgress interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

}
