package org.ccsds.moims.mo.malprototype.iptest.consumer;

/**
 * Consumer adapter for IPTest service.
 */
public abstract class IPTestAdapter extends org.ccsds.moims.mo.mal.consumer.MALInteractionAdapter
{
  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation testSubmit.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testSubmitAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation testSubmit.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testSubmitErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation request.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void requestResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation request.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void requestErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement is received from a provider for the operation invoke.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE response is received from a provider for the operation invoke.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement error is received from a provider for the operation invoke.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE response error is received from a provider for the operation invoke.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement is received from a provider for the operation progress.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS update is received from a provider for the operation progress.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Integer0 _Integer0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressUpdateReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Integer _Integer0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS response is received from a provider for the operation progress.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement error is received from a provider for the operation progress.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS update error is received from a provider for the operation progress.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressUpdateErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS response error is received from a provider for the operation progress.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement error is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub deregister acknowledgement is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub update is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Identifier0 _Identifier0 Argument number 0 as defined by the service operation.
   * @param _UpdateHeaderList1 _UpdateHeaderList1 Argument number 1 as defined by the service operation.
   * @param _TestUpdateList2 _TestUpdateList2 Argument number 2 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorNotifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Identifier _Identifier0, org.ccsds.moims.mo.mal.structures.UpdateHeaderList _UpdateHeaderList1, org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList _TestUpdateList2, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub update error is received from a broker for the operation monitor.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation getResult.
   * @param msgHeader msgHeader The header of the received message.
   * @param _IPTestResult0 _IPTestResult0 Argument number 0 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void getResultResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.malprototype.iptest.structures.IPTestResult _IPTestResult0, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation getResult.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void getResultErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation publishUpdates.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishUpdatesAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation publishUpdates.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishUpdatesErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation publishRegister.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation publishRegister.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation publishDeregister.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation publishDeregister.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void publishDeregisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation testMultipleNotify.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMultipleNotifyAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation testMultipleNotify.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testMultipleNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider for the operation submitMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void submitMultiAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider for the operation submitMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void submitMultiErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation requestMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param _Element1 _Element1 Argument number 1 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void requestMultiResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, org.ccsds.moims.mo.mal.structures.Element _Element1, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation requestMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void requestMultiErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement is received from a provider for the operation invokeMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param _Element1 _Element1 Argument number 1 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeMultiAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, org.ccsds.moims.mo.mal.structures.Element _Element1, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE response is received from a provider for the operation invokeMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param _Element1 _Element1 Argument number 1 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeMultiResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, org.ccsds.moims.mo.mal.structures.Element _Element1, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement error is received from a provider for the operation invokeMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeMultiAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE response error is received from a provider for the operation invokeMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void invokeMultiResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement is received from a provider for the operation progressMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param _Element1 _Element1 Argument number 1 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressMultiAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, org.ccsds.moims.mo.mal.structures.Element _Element1, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS update is received from a provider for the operation progressMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Integer0 _Integer0 Argument number 0 as defined by the service operation.
   * @param _Element1 _Element1 Argument number 1 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressMultiUpdateReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, Integer _Integer0, org.ccsds.moims.mo.mal.structures.Element _Element1, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS response is received from a provider for the operation progressMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @param _Element1 _Element1 Argument number 1 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressMultiResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, String _String0, org.ccsds.moims.mo.mal.structures.Element _Element1, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement error is received from a provider for the operation progressMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressMultiAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS update error is received from a provider for the operation progressMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressMultiUpdateErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS response error is received from a provider for the operation progressMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void progressMultiResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement is received from a broker for the operation monitorMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorMultiRegisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement error is received from a broker for the operation monitorMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorMultiRegisterErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub deregister acknowledgement is received from a broker for the operation monitorMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorMultiDeregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub update is received from a broker for the operation monitorMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param _Identifier0 _Identifier0 Argument number 0 as defined by the service operation.
   * @param _UpdateHeaderList1 _UpdateHeaderList1 Argument number 1 as defined by the service operation.
   * @param _TestUpdateList2 _TestUpdateList2 Argument number 2 as defined by the service operation.
   * @param _ElementList3 _ElementList3 Argument number 3 as defined by the service operation.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorMultiNotifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.structures.Identifier _Identifier0, org.ccsds.moims.mo.mal.structures.UpdateHeaderList _UpdateHeaderList1, org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList _TestUpdateList2, org.ccsds.moims.mo.mal.structures.ElementList _ElementList3, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PubSub update error is received from a broker for the operation monitorMulti.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void monitorMultiNotifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider for the operation testRequestEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testRequestEmptyBodyResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider for the operation testRequestEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testRequestEmptyBodyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement is received from a provider for the operation testInvokeEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testInvokeEmptyBodyAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE response is received from a provider for the operation testInvokeEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testInvokeEmptyBodyResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement error is received from a provider for the operation testInvokeEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testInvokeEmptyBodyAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when an INVOKE response error is received from a provider for the operation testInvokeEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testInvokeEmptyBodyResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement is received from a provider for the operation testProgressEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testProgressEmptyBodyAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS update is received from a provider for the operation testProgressEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testProgressEmptyBodyUpdateReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS response is received from a provider for the operation testProgressEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testProgressEmptyBodyResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement error is received from a provider for the operation testProgressEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testProgressEmptyBodyAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS update error is received from a provider for the operation testProgressEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testProgressEmptyBodyUpdateErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a PROGRESS response error is received from a provider for the operation testProgressEmptyBody.
   * @param msgHeader msgHeader The header of the received message.
   * @param error error The received error message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   */
  public void testProgressEmptyBodyResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.MALStandardError error, java.util.Map qosProperties)
  {
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void submitAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTSUBMIT_OP_NUMBER:
        testSubmitAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHUPDATES_OP_NUMBER:
        publishUpdatesAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHREGISTER_OP_NUMBER:
        publishRegisterAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHDEREGISTER_OP_NUMBER:
        publishDeregisterAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTMULTIPLENOTIFY_OP_NUMBER:
        testMultipleNotifyAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._SUBMITMULTI_OP_NUMBER:
        submitMultiAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a SUBMIT acknowledgement error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void submitErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTSUBMIT_OP_NUMBER:
        testSubmitErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHUPDATES_OP_NUMBER:
        publishUpdatesErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHREGISTER_OP_NUMBER:
        publishRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHDEREGISTER_OP_NUMBER:
        publishDeregisterErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTMULTIPLENOTIFY_OP_NUMBER:
        testMultipleNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._SUBMITMULTI_OP_NUMBER:
        submitMultiErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a REQUEST response is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void requestResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALMessageBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._REQUEST_OP_NUMBER:
        requestResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._GETRESULT_OP_NUMBER:
        getResultResponseReceived(msgHeader, (org.ccsds.moims.mo.malprototype.iptest.structures.IPTestResult) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestResult()), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._REQUESTMULTI_OP_NUMBER:
        requestMultiResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTREQUESTEMPTYBODY_OP_NUMBER:
        testRequestEmptyBodyResponseReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a REQUEST response error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void requestErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._REQUEST_OP_NUMBER:
        requestErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._GETRESULT_OP_NUMBER:
        getResultErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._REQUESTMULTI_OP_NUMBER:
        requestMultiErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTREQUESTEMPTYBODY_OP_NUMBER:
        testRequestEmptyBodyErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void invokeAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALMessageBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKE_OP_NUMBER:
        invokeAckReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKEMULTI_OP_NUMBER:
        invokeMultiAckReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTINVOKEEMPTYBODY_OP_NUMBER:
        testInvokeEmptyBodyAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when an INVOKE acknowledgement error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void invokeAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKE_OP_NUMBER:
        invokeAckErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKEMULTI_OP_NUMBER:
        invokeMultiAckErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTINVOKEEMPTYBODY_OP_NUMBER:
        testInvokeEmptyBodyAckErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when an INVOKE response is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void invokeResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALMessageBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKE_OP_NUMBER:
        invokeResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKEMULTI_OP_NUMBER:
        invokeMultiResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTINVOKEEMPTYBODY_OP_NUMBER:
        testInvokeEmptyBodyResponseReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when an INVOKE response error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void invokeResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKE_OP_NUMBER:
        invokeResponseErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKEMULTI_OP_NUMBER:
        invokeMultiResponseErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTINVOKEEMPTYBODY_OP_NUMBER:
        testInvokeEmptyBodyResponseErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void progressAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALMessageBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESS_OP_NUMBER:
        progressAckReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESSMULTI_OP_NUMBER:
        progressMultiAckReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTPROGRESSEMPTYBODY_OP_NUMBER:
        testProgressEmptyBodyAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PROGRESS acknowledgement error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void progressAckErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESS_OP_NUMBER:
        progressAckErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESSMULTI_OP_NUMBER:
        progressMultiAckErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTPROGRESSEMPTYBODY_OP_NUMBER:
        testProgressEmptyBodyAckErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PROGRESS update is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void progressUpdateReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALMessageBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESS_OP_NUMBER:
        progressUpdateReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE))).getIntegerValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESSMULTI_OP_NUMBER:
        progressMultiUpdateReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE)) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(Integer.MAX_VALUE))).getIntegerValue(), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTPROGRESSEMPTYBODY_OP_NUMBER:
        testProgressEmptyBodyUpdateReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PROGRESS update error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void progressUpdateErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESS_OP_NUMBER:
        progressUpdateErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESSMULTI_OP_NUMBER:
        progressMultiUpdateErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTPROGRESSEMPTYBODY_OP_NUMBER:
        testProgressEmptyBodyUpdateErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PROGRESS response is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void progressResponseReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALMessageBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESS_OP_NUMBER:
        progressResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESSMULTI_OP_NUMBER:
        progressMultiResponseReceived(msgHeader, (body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union("")) == null) ? null : ((org.ccsds.moims.mo.mal.structures.Union) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Union(""))).getStringValue(), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTPROGRESSEMPTYBODY_OP_NUMBER:
        testProgressEmptyBodyResponseReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PROGRESS response error is received from a provider.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void progressResponseErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESS_OP_NUMBER:
        progressResponseErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESSMULTI_OP_NUMBER:
        progressMultiResponseErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTPROGRESSEMPTYBODY_OP_NUMBER:
        testProgressEmptyBodyResponseErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void registerAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITOR_OP_NUMBER:
        monitorRegisterAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITORMULTI_OP_NUMBER:
        monitorMultiRegisterAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub register acknowledgement error is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void registerErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITOR_OP_NUMBER:
        monitorRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITORMULTI_OP_NUMBER:
        monitorMultiRegisterErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub update is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void notifyReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALNotifyBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    if ((org.ccsds.moims.mo.malprototype.MALPrototypeHelper.MALPROTOTYPE_AREA_NUMBER.equals(msgHeader.getServiceArea())) && (org.ccsds.moims.mo.malprototype.iptest.IPTestHelper.IPTEST_SERVICE_NUMBER.equals(msgHeader.getService())))
    {
      switch (msgHeader.getOperation().getValue())
      {
        case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITOR_OP_NUMBER:
          monitorNotifyReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()), (org.ccsds.moims.mo.mal.structures.UpdateHeaderList) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UpdateHeaderList()), (org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList) body.getBodyElement(2, new org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList()), qosProperties);
          break;
        case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITORMULTI_OP_NUMBER:
          monitorMultiNotifyReceived(msgHeader, (org.ccsds.moims.mo.mal.structures.Identifier) body.getBodyElement(0, new org.ccsds.moims.mo.mal.structures.Identifier()), (org.ccsds.moims.mo.mal.structures.UpdateHeaderList) body.getBodyElement(1, new org.ccsds.moims.mo.mal.structures.UpdateHeaderList()), (org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList) body.getBodyElement(2, new org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList()), (org.ccsds.moims.mo.mal.structures.ElementList) body.getBodyElement(3, null), qosProperties);
          break;
        default:
          throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
      }
    }
    else
    {
      notifyReceivedFromOtherService(msgHeader, body, qosProperties);
    }
  }

  /**
   * Called by the MAL when a PubSub update error is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void notifyErrorReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALErrorBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITOR_OP_NUMBER:
        monitorNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITORMULTI_OP_NUMBER:
        monitorMultiNotifyErrorReceived(msgHeader, body.getError(), qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub deregister acknowledgement is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public final void deregisterAckReceived(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
    switch (msgHeader.getOperation().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITOR_OP_NUMBER:
        monitorDeregisterAckReceived(msgHeader, qosProperties);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._MONITORMULTI_OP_NUMBER:
        monitorMultiDeregisterAckReceived(msgHeader, qosProperties);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALException("Consumer adapter was not expecting operation number " + msgHeader.getOperation().getValue());
    }
  }

  /**
   * Called by the MAL when a PubSub update from another service is received from a broker.
   * @param msgHeader msgHeader The header of the received message.
   * @param body body The body of the received message.
   * @param qosProperties qosProperties The QoS properties associated with the message.
   * @throws org.ccsds.moims.mo.mal.MALException if an error is detected processing the message.
   */
  public void notifyReceivedFromOtherService(org.ccsds.moims.mo.mal.transport.MALMessageHeader msgHeader, org.ccsds.moims.mo.mal.transport.MALNotifyBody body, java.util.Map qosProperties) throws org.ccsds.moims.mo.mal.MALException
  {
  }

}
