package org.ccsds.moims.mo.malprototype.iptest.provider;

/**
 * Provider Inheritance skeleton for IPTestInheritanceSkeleton service.
 */
public abstract class IPTestInheritanceSkeleton implements org.ccsds.moims.mo.mal.provider.MALInteractionHandler, org.ccsds.moims.mo.malprototype.iptest.provider.IPTestSkeleton, org.ccsds.moims.mo.malprototype.iptest.provider.IPTestHandler
{
  private org.ccsds.moims.mo.mal.provider.MALProviderSet providerSet = new org.ccsds.moims.mo.mal.provider.MALProviderSet(org.ccsds.moims.mo.malprototype.iptest.IPTestHelper.IPTEST_SERVICE);
  /**
   * Implements the setSkeleton method of the handler interface but does nothing as this is the skeleton.
   * @param skeleton skeleton Not used in the inheritance pattern (the skeleton is 'this'.
   */
  public void setSkeleton(org.ccsds.moims.mo.malprototype.iptest.provider.IPTestSkeleton skeleton)
  {
    // Not used in the inheritance pattern (the skeleton is 'this');
  }

  /**
   * Adds the supplied MAL provider to the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malInitialize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.addProvider(provider);
  }

  /**
   * Removes the supplied MAL provider from the internal list of providers used for PubSub.
   * @param provider provider The provider to add.
   * @throws org.ccsds.moims.mo.mal.MALException If an error is detected.
   */
  public void malFinalize(org.ccsds.moims.mo.mal.provider.MALProvider provider) throws org.ccsds.moims.mo.mal.MALException
  {
    providerSet.removeProvider(provider);
  }

  /**
   * Creates a publisher object using the current registered provider set for the PubSub operation monitor.
   * @param domain domain the domain used for publishing.
   * @param networkZone networkZone the network zone used for publishing.
   * @param sessionType sessionType the session used for publishing.
   * @param sessionName sessionName the session name used for publishing.
   * @param qos qos the QoS used for publishing.
   * @param qosProps qosProps the QoS properties used for publishing.
   * @param priority priority the priority used for publishing.
   * @return The new publisher object.
   * @throws org.ccsds.moims.mo.mal.MALException if a problem is detected during creation of the publisher.
   */
  public org.ccsds.moims.mo.malprototype.iptest.provider.MonitorPublisher createMonitorPublisher(org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType sessionType, org.ccsds.moims.mo.mal.structures.Identifier sessionName, org.ccsds.moims.mo.mal.structures.QoSLevel qos, java.util.Map qosProps, org.ccsds.moims.mo.mal.structures.UInteger priority) throws org.ccsds.moims.mo.mal.MALException
  {
    return new org.ccsds.moims.mo.malprototype.iptest.provider.MonitorPublisher(providerSet.createPublisherSet(org.ccsds.moims.mo.malprototype.iptest.IPTestHelper.MONITOR_OP, domain, networkZone, sessionType, sessionName, qos, qosProps, priority));
  }

  /**
   * Creates a publisher object using the current registered provider set for the PubSub operation monitorMulti.
   * @param domain domain the domain used for publishing.
   * @param networkZone networkZone the network zone used for publishing.
   * @param sessionType sessionType the session used for publishing.
   * @param sessionName sessionName the session name used for publishing.
   * @param qos qos the QoS used for publishing.
   * @param qosProps qosProps the QoS properties used for publishing.
   * @param priority priority the priority used for publishing.
   * @return The new publisher object.
   * @throws org.ccsds.moims.mo.mal.MALException if a problem is detected during creation of the publisher.
   */
  public org.ccsds.moims.mo.malprototype.iptest.provider.MonitorMultiPublisher createMonitorMultiPublisher(org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType sessionType, org.ccsds.moims.mo.mal.structures.Identifier sessionName, org.ccsds.moims.mo.mal.structures.QoSLevel qos, java.util.Map qosProps, org.ccsds.moims.mo.mal.structures.UInteger priority) throws org.ccsds.moims.mo.mal.MALException
  {
    return new org.ccsds.moims.mo.malprototype.iptest.provider.MonitorMultiPublisher(providerSet.createPublisherSet(org.ccsds.moims.mo.malprototype.iptest.IPTestHelper.MONITORMULTI_OP, domain, networkZone, sessionType, sessionName, qos, qosProps, priority));
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSend(org.ccsds.moims.mo.mal.provider.MALInteraction interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._SEND_OP_NUMBER:
        send((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), interaction);
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._SENDMULTI_OP_NUMBER:
        sendMulti((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), interaction);
        break;
      default:
        throw new org.ccsds.moims.mo.mal.MALInteractionException(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleSubmit(org.ccsds.moims.mo.mal.provider.MALSubmit interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTSUBMIT_OP_NUMBER:
        testSubmit((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHUPDATES_OP_NUMBER:
        publishUpdates((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHREGISTER_OP_NUMBER:
        publishRegister((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishRegister) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishRegister()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PUBLISHDEREGISTER_OP_NUMBER:
        publishDeregister((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishDeregister) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishDeregister()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTMULTIPLENOTIFY_OP_NUMBER:
        testMultipleNotify((org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.TestPublishUpdate()), interaction);
        interaction.sendAcknowledgement();
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._SUBMITMULTI_OP_NUMBER:
        submitMulti((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), interaction);
        interaction.sendAcknowledgement();
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleRequest(org.ccsds.moims.mo.mal.provider.MALRequest interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._REQUEST_OP_NUMBER:
        String requestRt = request((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), interaction);
        interaction.sendResponse((requestRt == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(requestRt));
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._GETRESULT_OP_NUMBER:
        interaction.sendResponse(getResult((org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(0, null), interaction));
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._REQUESTMULTI_OP_NUMBER:
        org.ccsds.moims.mo.malprototype.iptest.body.RequestMultiResponse requestMultiRt = requestMulti((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), interaction);
        interaction.sendResponse((requestMultiRt.getBodyElement0() == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(requestMultiRt.getBodyElement0()), requestMultiRt.getBodyElement1());
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTREQUESTEMPTYBODY_OP_NUMBER:
        testRequestEmptyBody((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), interaction);
        interaction.sendResponse();
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleInvoke(org.ccsds.moims.mo.mal.provider.MALInvoke interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKE_OP_NUMBER:
        invoke((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), new InvokeInteraction(interaction));
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._INVOKEMULTI_OP_NUMBER:
        invokeMulti((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), new InvokeMultiInteraction(interaction));
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTINVOKEEMPTYBODY_OP_NUMBER:
        testInvokeEmptyBody((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), new TestInvokeEmptyBodyInteraction(interaction));
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

  /**
   * Called by the provider MAL layer on reception of a message to handle the interaction.
   * @param interaction interaction the interaction object.
   * @param body body the message body.
   * @throws org.ccsds.moims.mo.mal.MALException if there is a internal error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a operation interaction error.
   */
  public void handleProgress(org.ccsds.moims.mo.mal.provider.MALProgress interaction, org.ccsds.moims.mo.mal.transport.MALMessageBody body) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    switch (interaction.getOperation().getNumber().getValue())
    {
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESS_OP_NUMBER:
        progress((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), new ProgressInteraction(interaction));
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._PROGRESSMULTI_OP_NUMBER:
        progressMulti((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), (org.ccsds.moims.mo.mal.structures.Element) body.getBodyElement(1, null), new ProgressMultiInteraction(interaction));
        break;
      case org.ccsds.moims.mo.malprototype.iptest.IPTestHelper._TESTPROGRESSEMPTYBODY_OP_NUMBER:
        testProgressEmptyBody((org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition) body.getBodyElement(0, new org.ccsds.moims.mo.malprototype.iptest.structures.IPTestDefinition()), new TestProgressEmptyBodyInteraction(interaction));
        break;
      default:
        interaction.sendError(new org.ccsds.moims.mo.mal.MALStandardError(org.ccsds.moims.mo.mal.MALHelper.UNSUPPORTED_OPERATION_ERROR_NUMBER, new org.ccsds.moims.mo.mal.structures.Union("Unknown operation")));
    }
  }

}
