package org.ccsds.moims.mo.malprototype.iptest.provider;

/**
 * The skeleton interface for the IPTest service.
 */
public interface IPTestSkeleton
{
  /**
   * Creates a publisher object using the current registered provider set for the PubSub operation monitor.
   * @param domain domain the domain used for publishing.
   * @param networkZone networkZone the network zone used for publishing.
   * @param sessionType sessionType the session used for publishing.
   * @param sessionName sessionName the session name used for publishing.
   * @param qos qos the QoS used for publishing.
   * @param qosProps qosProps the QoS properties used for publishing.
   * @param priority priority the priority used for publishing.
   * @return The new publisher object.
   * @throws org.ccsds.moims.mo.mal.MALException if a problem is detected during creation of the publisher.
   */
  org.ccsds.moims.mo.malprototype.iptest.provider.MonitorPublisher createMonitorPublisher(org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType sessionType, org.ccsds.moims.mo.mal.structures.Identifier sessionName, org.ccsds.moims.mo.mal.structures.QoSLevel qos, java.util.Map qosProps, org.ccsds.moims.mo.mal.structures.UInteger priority) throws org.ccsds.moims.mo.mal.MALException;
  /**
   * Creates a publisher object using the current registered provider set for the PubSub operation monitorMulti.
   * @param domain domain the domain used for publishing.
   * @param networkZone networkZone the network zone used for publishing.
   * @param sessionType sessionType the session used for publishing.
   * @param sessionName sessionName the session name used for publishing.
   * @param qos qos the QoS used for publishing.
   * @param qosProps qosProps the QoS properties used for publishing.
   * @param priority priority the priority used for publishing.
   * @return The new publisher object.
   * @throws org.ccsds.moims.mo.mal.MALException if a problem is detected during creation of the publisher.
   */
  org.ccsds.moims.mo.malprototype.iptest.provider.MonitorMultiPublisher createMonitorMultiPublisher(org.ccsds.moims.mo.mal.structures.IdentifierList domain, org.ccsds.moims.mo.mal.structures.Identifier networkZone, org.ccsds.moims.mo.mal.structures.SessionType sessionType, org.ccsds.moims.mo.mal.structures.Identifier sessionName, org.ccsds.moims.mo.mal.structures.QoSLevel qos, java.util.Map qosProps, org.ccsds.moims.mo.mal.structures.UInteger priority) throws org.ccsds.moims.mo.mal.MALException;
}
