package org.ccsds.moims.mo.malprototype.iptest.provider;

/**
 * Provider INVOKE interaction class for IPTest::invoke operation.
 */
public class InvokeInteraction
{
  private org.ccsds.moims.mo.mal.provider.MALInvoke interaction;
  /**
   * Wraps the provided MAL interaction object with methods for sending responses to an INVOKE interaction from a provider.
   * @param interaction interaction The MAL interaction action object to use.
   */
  public InvokeInteraction(org.ccsds.moims.mo.mal.provider.MALInvoke interaction)
  {
    this.interaction = interaction;
  }

  /**
   * Returns the MAL interaction object used for returning messages from the provider.
   * @return The MAL interaction object provided in the constructor.
   */
  public org.ccsds.moims.mo.mal.provider.MALInvoke getInteraction()
  {
    return interaction;
  }

  /**
   * Sends a INVOKE acknowledge to the consumer.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @return Returns the MAL message created by the acknowledge.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendAcknowledgement(String _String0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendAcknowledgement((_String0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_String0));
  }

  /**
   * Sends a INVOKE response to the consumer.
   * @param _String0 _String0 Argument number 0 as defined by the service operation.
   * @return Returns the MAL message created by the response.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendResponse(String _String0) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendResponse((_String0 == null) ? null : new org.ccsds.moims.mo.mal.structures.Union(_String0));
  }

  /**
   * Sends an error to the consumer.
   * @param error error The MAL error to send to the consumer.
   * @return Returns the MAL message created by the error.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public org.ccsds.moims.mo.mal.transport.MALMessage sendError(org.ccsds.moims.mo.mal.MALStandardError error) throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    return interaction.sendError(error);
  }

}
