package org.ccsds.moims.mo.malprototype.iptest.provider;

/**
 * Publisher class for the monitor operation.
 */
public final class MonitorPublisher
{
  private org.ccsds.moims.mo.mal.provider.MALPublisherSet publisherSet;
  /**
   * Creates an instance of this class using the supplied publisher set.
   * @param publisherSet publisherSet The set of broker connections to use when registering and publishing.
   */
  public MonitorPublisher(org.ccsds.moims.mo.mal.provider.MALPublisherSet publisherSet)
  {
    this.publisherSet = publisherSet;
  }

  /**
   * Registers this provider implementation to the set of broker connections.
   * @param entityKeys entityKeys The entity keys to use in the method.
   * @param listener listener The listener object to use for callback from the publisher.
   * @throws java.lang.IllegalArgumentException If any supplied argument is invalid.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void register(org.ccsds.moims.mo.mal.structures.EntityKeyList entityKeys, org.ccsds.moims.mo.mal.provider.MALPublishInteractionListener listener) throws java.lang.IllegalArgumentException, org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    publisherSet.register(entityKeys, listener);
  }

  /**
   * Asynchronously registers this provider implementation to the set of broker connections.
   * @param entityKeys entityKeys The entity keys to use in the method.
   * @param listener listener The listener object to use for callback from the publisher.
   * @throws java.lang.IllegalArgumentException If any supplied argument is invalid.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void asyncRegister(org.ccsds.moims.mo.mal.structures.EntityKeyList entityKeys, org.ccsds.moims.mo.mal.provider.MALPublishInteractionListener listener) throws java.lang.IllegalArgumentException, org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    publisherSet.asyncRegister(entityKeys, listener);
  }

  /**
   * Publishes updates to the set of registered broker connections.
   * @param updateHeaderList updateHeaderList The headers of the updates being added.
   * @param _TestUpdate0 _TestUpdate0 Argument number 0 as defined by the service operation.
   * @throws java.lang.IllegalArgumentException If any supplied argument is invalid.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void publish(org.ccsds.moims.mo.mal.structures.UpdateHeaderList updateHeaderList, org.ccsds.moims.mo.malprototype.iptest.structures.TestUpdateList _TestUpdate0) throws java.lang.IllegalArgumentException, org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    publisherSet.publish(updateHeaderList, _TestUpdate0);
  }

  /**
   * Deregisters this provider implementation from the set of broker connections.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void deregister() throws org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    publisherSet.deregister();
  }

  /**
   * Asynchronously deregisters this provider implementation from the set of broker connections.
   * @param listener listener The listener object to use for callback from the publisher.
   * @throws java.lang.IllegalArgumentException If any supplied argument is invalid.
   * @throws org.ccsds.moims.mo.mal.MALInteractionException if there is a problem during the interaction as defined by the MAL specification.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void asyncDeregister(org.ccsds.moims.mo.mal.provider.MALPublishInteractionListener listener) throws java.lang.IllegalArgumentException, org.ccsds.moims.mo.mal.MALInteractionException, org.ccsds.moims.mo.mal.MALException
  {
    publisherSet.asyncDeregister(listener);
  }

  /**
   * Closes this publisher.
   * @throws org.ccsds.moims.mo.mal.MALException if there is an implementation exception.
   */
  public void close() throws org.ccsds.moims.mo.mal.MALException
  {
    publisherSet.close();
  }

}
